//-*-c++-*-
#ifndef INCLUDED_LockScope_h_
#define INCLUDED_LockScope_h_

#include "Shared/MutexLock.h"

//! Locks a MutexLock until the LockScope goes out of scope
/*! This can help prevent forgetting to do it if you function has multiple return points */
template<unsigned int num_doors>
class LockScope {
public:
	//!constructor, locks @a lock with @a id
	LockScope(MutexLock<num_doors>& lock, int id) : l(lock) {l.lock(id);}
	//!destructor, releases lock received in constructor
	~LockScope() { l.release(); }
protected:
	MutexLock<num_doors>& l; //!< the lock
};

/*! @file
 * @brief Defines LockScope, which locks a MutexLock until the LockScope goes out of scope
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_1 $
 * $Revision: 1.3 $
 * $State: Rel $
 * $Date: 2003/09/25 15:31:53 $
 */

#endif
