#include "Shared/Config.h"
#include "Behaviors/Mon/RawCamBehavior.h"
#include "Vision/RawCameraGenerator.h"
#include <stdio.h>
#include <string>
#include <ctype.h>
#include <OPENR/OPrimitiveControl.h>
#include <OPENR/OPENRAPI.h>

Config* config=NULL;

void* Config::setValue(section_t section, const char *key, const char *value,
											 bool /*updated*/) {
  switch (section) {
    case sec_wireless:
      if (strncasecmp(key,"id",29)==0) {
        wireless.id=atoi(value);
        return &wireless.id;
      }
      break;
    case sec_vision:
      if (strncasecmp(key,"white_balance",29)==0) {
        if (strncasecmp(value,"indoor",49)==0) {
          vision.white_balance=1;
        } else if (strncasecmp(value,"flourescent",49)==0) {
          vision.white_balance=3;
        } else if (strncasecmp(value,"outdoor",49)==0) {
          vision.white_balance=2;
        }
				//this will actually send the new setting to the system
				OPrimitiveID fbkID = 0;
				if(OPENR::OpenPrimitive(CameraLocator, &fbkID) != oSUCCESS){
					std::cout << "Open FbkImageSensor failure." << std::endl;
				} else {
					OPrimitiveControl_CameraParam owb(vision.white_balance);
					if(OPENR::ControlPrimitive(fbkID, oprmreqCAM_SET_WHITE_BALANCE, &owb, sizeof(owb), 0, 0) != oSUCCESS){
						std::cout << "CAM_SET_WHITE_BALANCE : Failed!" << std::endl;
					}
					OPENR::ClosePrimitive(fbkID);
				}
        return &vision.white_balance;
      } else if (strncasecmp(key,"gain",29)==0) {
        if (strncasecmp(value,"low",49)==0) {
          vision.gain=1;
        } else if (strncasecmp(value,"mid",49)==0) {
          vision.gain=2;
        } else if (strncasecmp(value,"high",49)==0) {
          vision.gain=3;
        }
				//this will actually send the new setting to the system
				OPrimitiveID fbkID = 0;
				if(OPENR::OpenPrimitive(CameraLocator, &fbkID) != oSUCCESS){
					std::cout << "Open FbkImageSensor failure." << std::endl;
				} else {
					OPrimitiveControl_CameraParam ogain(vision.gain);
					if(OPENR::ControlPrimitive(fbkID, oprmreqCAM_SET_GAIN, &ogain, sizeof(ogain), 0, 0) != oSUCCESS)
						std::cout << "CAM_SET_GAIN : Failed!" << std::endl;
					OPENR::ClosePrimitive(fbkID);
				}
        return &vision.gain;
      } else if (strncasecmp(key,"shutter_speed",29)==0) {
        if (strncasecmp(value,"slow",49)==0) {
          vision.shutter_speed=1;
        } else if (strncasecmp(value,"mid",49)==0) {
          vision.shutter_speed=2;
        } else if (strncasecmp(value,"fast",49)==0) {
          vision.shutter_speed=3;
        }
				//this will actually send the new setting to the system
				OPrimitiveID fbkID = 0;
				if(OPENR::OpenPrimitive(CameraLocator, &fbkID) != oSUCCESS){
					std::cout << "Open FbkImageSensor failure." << std::endl;
				} else {
					OPrimitiveControl_CameraParam oshutter(vision.shutter_speed);
					if(OPENR::ControlPrimitive(fbkID,oprmreqCAM_SET_SHUTTER_SPEED, &oshutter, sizeof(oshutter), 0, 0) != oSUCCESS)
						std::cout << "CAM_SET_SHUTTER_SPEED : Failed!" << std::endl;
					OPENR::ClosePrimitive(fbkID);
				}
        return &vision.shutter_speed;
      } else if (strncasecmp(key,"resolution",29)==0) {
        if (strncasecmp(value,"full",49)==0) {
          vision.resolution=1;
        } else if (strncasecmp(value,"half",49)==0) {
          vision.resolution=2;
        } else if (strncasecmp(value,"quarter",49)==0) {
          vision.resolution=3;
        }
        return &vision.resolution;
      } else if (strncasecmp(key,"thresh",29)==0) {
				vision.thresh.push_back(value);
        return &vision.thresh;
      } else if (strncasecmp(key,"colors",29)==0) {
        strncpy(vision.colors,value,49);
        return &vision.colors;
      } else if (strncasecmp(key,"raw_port",29)==0) {
        vision.rawcam_port=atoi(value);
        return &vision.rawcam_port;
      } else if (strncasecmp(key,"rle_port",29)==0) {
        vision.rle_port=atoi(value);
        return &vision.rle_port;
      } else if (strncasecmp(key,"obj_port",29)==0) {
        vision.obj_port=atoi(value);
        return &vision.obj_port;
      } else if (strncasecmp(key,"restore_image",29)==0) {
        vision.restore_image=atoi(value);
        return &vision.obj_port;
      } else if (strncasecmp(key,"jpeg_dct_method",29)==0) {
        if (strncasecmp(value,"islow",49)==0) {
          vision.jpeg_dct_method=JDCT_ISLOW;
        } else if (strncasecmp(value,"ifast",49)==0) {
          vision.jpeg_dct_method=JDCT_IFAST;
        } else if (strncasecmp(value,"float",49)==0) {
          vision.jpeg_dct_method=JDCT_FLOAT;
				}
				return &vision.jpeg_dct_method;
      } else if (strncasecmp(key,"rawcam_encoding",29)==0) {
        if (strncasecmp(value,"color",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_COLOR;
          vision.rawcam_channel=RawCameraGenerator::CHAN_Y;
        } else if (strncasecmp(value,"y_only",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_SINGLE_CHANNEL;
          vision.rawcam_channel=RawCameraGenerator::CHAN_Y;
        } else if (strncasecmp(value,"uv_only",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_COLOR;
					vision.rawcam_channel=-1;
        } else if (strncasecmp(value,"u_only",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_SINGLE_CHANNEL;
          vision.rawcam_channel=RawCameraGenerator::CHAN_U;
        } else if (strncasecmp(value,"v_only",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_SINGLE_CHANNEL;
          vision.rawcam_channel=RawCameraGenerator::CHAN_V;
        } else if (strncasecmp(value,"y_dx_only",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_SINGLE_CHANNEL;
          vision.rawcam_channel=RawCameraGenerator::CHAN_Y_DX;
        } else if (strncasecmp(value,"y_dy_only",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_SINGLE_CHANNEL;
          vision.rawcam_channel=RawCameraGenerator::CHAN_Y_DY;
        } else if (strncasecmp(value,"y_dxdy_only",49)==0) {
          vision.rawcam_encoding=vision_config::ENCODE_SINGLE_CHANNEL;
          vision.rawcam_channel=RawCameraGenerator::CHAN_Y_DXDY;
        }
        return &vision.rawcam_encoding;
      } else if (strncasecmp(key,"rawcam_compression",29)==0) {
        if (strncasecmp(value,"none",49)==0) {
          vision.rawcam_compression=vision_config::COMPRESS_NONE;
        } else if (strncasecmp(value,"jpeg",49)==0) {
          vision.rawcam_compression=vision_config::COMPRESS_JPEG;
				}
				return &vision.rawcam_compression;
      } else if (strncasecmp(key,"rawcam_compress_quality",29)==0) {
        vision.rawcam_compress_quality=atoi(value);
        return &vision.rawcam_compress_quality;
      } else if (strncasecmp(key,"rawcam_y_skip",29)==0) {
        vision.rawcam_y_skip=atoi(value);
        return &vision.rawcam_y_skip;
      } else if (strncasecmp(key,"rawcam_uv_skip",29)==0) {
        vision.rawcam_uv_skip=atoi(value);
        return &vision.rawcam_uv_skip;
      } else if (strncasecmp(key,"rlecam_skip",29)==0) {
        vision.rlecam_skip=atoi(value);
        return &vision.rlecam_skip;
      } else if (strncasecmp(key,"rlecam_channel",29)==0) {
        vision.rlecam_channel=atoi(value);
        return &vision.rlecam_channel;
      } else if (strncasecmp(key,"rlecam_compression",29)==0) {
        if (strncasecmp(value,"none",49)==0) {
          vision.rlecam_compression=vision_config::COMPRESS_NONE;
        } else if (strncasecmp(value,"rle",49)==0) {
          vision.rlecam_compression=vision_config::COMPRESS_RLE;
				}
				return &vision.rlecam_compression;
			}
      break;
    case sec_main:
      if (strncasecmp(key,"console_port",29)==0) {
        main.console_port=atoi(value);
        return &main.console_port;
      } else if (strncasecmp(key,"stderr_port",29)==0) {
        main.stderr_port=atoi(value);
        return &main.stderr_port;
      } else if (strncasecmp(key,"error_level",29)==0) {
        main.error_level=atoi(value);
        return &main.error_level;
      } else if (strncasecmp(key,"debug_level",29)==0) {
        main.debug_level=atoi(value);
        return &main.debug_level;
      } else if (strncasecmp(key,"verbose_level",29)==0) {
        main.verbose_level=atoi(value);
        return &main.verbose_level;
      } else if (strncasecmp(key,"wsjoints_port",29)==0) {
        main.wsjoints_port=atoi(value);
        return &main.wsjoints_port;
      } else if (strncasecmp(key,"wspids_port",29)==0) {
        main.wspids_port=atoi(value);
        return &main.wspids_port;
      } else if (strncasecmp(key,"headControl_port",29)==0) {
        main.headControl_port=atoi(value);
        return &main.headControl_port;
      } else if (strncasecmp(key,"walkControl_port",29)==0) {
        main.walkControl_port=atoi(value);
        return &main.walkControl_port;
      } else if (strncasecmp(key,"estopControl_port",29)==0) {
        main.estopControl_port=atoi(value);
        return &main.estopControl_port;
      } else if (strncasecmp(key,"aibo3d_port",29)==0) {
        main.aibo3d_port=atoi(value);
        return &main.aibo3d_port;
      } else if (strncasecmp(key,"wmmonitor_port",29)==0) {
        main.wmmonitor_port=atoi(value);
        return &main.wmmonitor_port;
      } else if (strncasecmp(key,"use_VT100",29)==0) {
        main.use_VT100=extractBool(value);
        return &main.use_VT100;
      }
      break;
    case sec_behaviors:
      break;
    case sec_controller:
      if (strncasecmp(key,"gui_port",29)==0) {
        controller.gui_port = atoi(value);
        return &controller.gui_port ;
      } else if (strncasecmp(key,"select_snd",29)==0) {
        strncpy(controller.select_snd,value,49);
        return &controller.select_snd;
      } else if (strncasecmp(key,"next_snd",29)==0) {
        strncpy(controller.next_snd,value,49);
        return &controller.next_snd;
      } else if (strncasecmp(key,"prev_snd",29)==0) {
        strncpy(controller.prev_snd,value,49);
        return &controller.prev_snd;
      } else if (strncasecmp(key,"read_snd",29)==0) {
        strncpy(controller.read_snd,value,49);
        return &controller.read_snd;
      } else if (strncasecmp(key,"cancel_snd",29)==0) {
        strncpy(controller.cancel_snd,value,49);
        return &controller.cancel_snd;
      } else if (strncasecmp(key,"error_snd",29)==0) {
        strncpy(controller.error_snd,value,49);
        return &controller.error_snd;
      }
      break;
    case sec_motion:
      if (strncasecmp(key,"root",29)==0) {
        motion.root=value;
        return &motion.root;
			} else if (strncasecmp(key,"walk",29)==0) {
        motion.walk=value;
        return &motion.walk;
      } else if (strncasecmp(key,"estop_on_snd",29)==0) {
        strncpy(motion.estop_on_snd,value,49);
        return &motion.estop_on_snd;
      } else if (strncasecmp(key,"estop_off_snd",29)==0) {
        strncpy(motion.estop_off_snd,value,49);
        return &motion.estop_off_snd;
      } else if (strncasecmp(key,"max_head_tilt_speed",29)==0) {
					motion.max_head_tilt_speed=atof(value);
      } else if (strncasecmp(key,"max_head_pan_speed",29)==0) {
					motion.max_head_pan_speed=atof(value);
      } else if (strncasecmp(key,"max_head_roll_speed",29)==0) {
					motion.max_head_roll_speed=atof(value);
      }
      break;
    case sec_worldmodel2:
      if (strncasecmp(key,"dm_port",29)==0) {
        worldmodel2.dm_port = atoi(value);
        return &worldmodel2.dm_port ;
      } else if (strncasecmp(key,"hm_port",29)==0) {
        worldmodel2.hm_port = atoi(value);
        return &worldmodel2.hm_port ;
      } else if (strncasecmp(key,"gm_port",29)==0) {
        worldmodel2.gm_port = atoi(value);
        return &worldmodel2.gm_port ;
      } else if (strncasecmp(key,"fs_port",29)==0) {
        worldmodel2.fs_port = atoi(value);
        return &worldmodel2.fs_port ;
      }
      break;
    case sec_sound:
      if (strncasecmp(key,"root",29)==0) {
        sound.root=value;
        return &sound.root;
			} else if (strncasecmp(key,"volume",29)==0) {
				if(strncasecmp(value,"mute",49)==0)
					sound.volume=ospkvolinfdB;
				else if(strncasecmp(value,"level_1",49)==0)
					sound.volume=ospkvol25dB;
				else if(strncasecmp(value,"level_2",49)==0)
					sound.volume=ospkvol18dB;
				else if(strncasecmp(value,"level_3",49)==0)
					sound.volume=ospkvol10dB;
				else
					sound.volume=strtol(value,NULL,0);
        return &sound.volume;
      } else if (strncasecmp(key,"sample_rate",29)==0) {
        sound.sample_rate = atoi(value);
        return &sound.sample_rate ;
      } else if (strncasecmp(key,"sample_bits",29)==0) {
        sound.sample_bits = atoi(value);
        return &sound.sample_bits ;
      } else if (strncasecmp(key,"preload",29)==0) {
        sound.preload.push_back(value);
        return &sound.preload ;
      }
      break;
    default:
      break;
  }
  return NULL;
}

Config::section_t Config::parseSection(const char* key) {
  if (strncasecmp(key,"wireless",29)==0) {
    return sec_wireless;
  } else if (strncasecmp(key,"vision",29)==0) {
    return sec_vision;
  } else if (strncasecmp(key,"main",29)==0) {
    return sec_main;
  } else if (strncasecmp(key,"behaviors",29)==0) {
    return sec_behaviors;
  } else if (strncasecmp(key,"controller",29)==0) {
    return sec_controller;
  } else if (strncasecmp(key,"motion",29)==0) {
    return sec_motion;
  } else if (strncasecmp(key,"worldmodel2",29)==0) {
    return sec_worldmodel2;
  } else if (strncasecmp(key,"sound",29)==0) {
    return sec_sound;
  } else {
    return sec_invalid;
  }
}

void Config::readConfig(const char* filename) {
  FILE* fp = fopen(filename, "r");
  char buf[80], key[30], value[50];
  section_t section=sec_invalid;
  if (fp==NULL) return;

	bool ignoring=false;
	std::vector<std::string> curmodel;
	char rdStr[orobotdesignNAME_MAX];
	memset(rdStr, 0, sizeof(rdStr));
	if (OPENR::GetRobotDesign(rdStr) != oSUCCESS) {
		printf("OPENR::GetRobotDesign() failed.\n");
		rdStr[0]='\0';
	}

	unsigned int lineno=0;
  while (fscanf(fp,"%79[^\n]\n", buf)!=EOF) {
		lineno++;
    if (sscanf(buf,"<%29[^>]>",key)>0) {
			if(key[0]=='/') {
				if(curmodel.size()==0) {
					printf("WARNING: not in a model specific section, line %d\n",lineno);
					continue;
				}
				bool subset=matchNoCase(&key[1],curmodel.back());
				bool superset=matchNoCase(curmodel.back(),&key[1]);
				if(subset && superset) {
					//printf("leaving modelsection %s\n",curmodel.back().c_str());
					curmodel.pop_back();
				} else if(superset) {
					while(curmodel.size()>0) {
						//printf("leaving modelsection %s (==%s)\n",curmodel.back().c_str(),&key[1]);
						curmodel.pop_back();
						if(!matchNoCase(curmodel.back(),&key[1]))
							break;
					}
				} else
					printf("WARNING: config model mismatch, line %d\n",lineno);
				
				ignoring=false; //scan through current model selection stack, see if we're still ignoring
				for(unsigned int i=0; i<curmodel.size(); i++)
					if(!matchNoCase(rdStr,curmodel[i])) {
						ignoring=true;
						break;
					}
				//printf("ignoring==%d\n",ignoring);
				
			} else {
				curmodel.push_back(key);
				//printf("entering section %s\n",curmodel.back().c_str());
				ignoring=ignoring || !matchNoCase(rdStr,key);
				//printf("ignoring==%d\n",ignoring);
			}
		} else if(!ignoring) {
			if (sscanf(buf,"[%29[^]]]",key)>0) {
				section=parseSection(key);
				//std::cout << "now parsing section " << section << std::endl;
			} else if (sscanf(buf,"%29[^=]=%49s",key,value)>1) {
				//printf("setValue(%d,'%s','%s');\n",section,key,value);
				setValue(section, key, value);    
			}
		}
  }
  fclose(fp);
}

bool Config::matchNoCase(const std::string& model, const std::string& pattern) {
	unsigned int i=0;
	if(i==pattern.size() && i==model.size())
		return true;
	if(i==pattern.size() || i==model.size())
		return false;
	while(pattern[i]!='*') {
		if(toupper(pattern[i])!=toupper(model[i]))
			return false;
		i++;
		if(i==pattern.size() && i==model.size())
			return true;
		if(i==pattern.size() || i==model.size())
			return false;
	}
	i=pattern.size()-1;
	unsigned int j=model.size()-1;
	while(pattern[i]!='*') {
		if(toupper(pattern[i])!=toupper(model[j]))
			return false;
		i--; j--;
	}
	return true;
}

bool Config::extractBool(const char * value) {
	int i=0;
	while(isspace(value[i])) i++;
	if(strncasecmp(&value[i],"t",29)==0)
		return true;
	else if(strncasecmp(&value[i],"f",29)==0)
		return false;
	else if(strncasecmp(&value[i],"true",29)==0)
		return true;
	else if(strncasecmp(&value[i],"false",29)==0)
		return false;
	else if(strncasecmp(&value[i],"y",29)==0)
		return true;
	else if(strncasecmp(&value[i],"n",29)==0)
		return false;
	else if(strncasecmp(&value[i],"yes",29)==0)
		return true;
	else if(strncasecmp(&value[i],"no",29)==0)
		return false;
	else
		return atoi(value);
}

/*! @file
 * @brief Implements Config, which provides global access to system configuration information
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_1 $
 * $Revision: 1.30 $
 * $State: Exp $
 * $Date: 2004/01/21 03:53:01 $
 */

