//-*-c++-*-
#ifndef INCLUDED_VisualTargetTrans_h_
#define INCLUDED_VisualTargetTrans_h_

#include "Events/EventRouter.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/debuget.h"
#include "Shared/WorldState.h"

//! causes a transition when a visual object is "close"
class VisualTargetTrans : public Transition {
public:
	//!constructor
	VisualTargetTrans(StateNode* destination, unsigned int source_id)
		: Transition(destination), sid(source_id), count(0) {}

	//!starts listening for the object specified by the source id in the constructor
	virtual void DoStart() {
		//serr->printf("VisualTargetTrans::DoStart() - enter\n");
		Transition::DoStart();
		count=0;
		erouter->addListener(this,EventBase::visObjEGID,sid);
		//serr->printf("VisualTargetTrans::DoStart() - leave\n");
	}

	//!called by StateNode when it becomes inactive - undo whatever you did in Enable()
	virtual void DoStop() {
		//serr->printf("VisualTargetTrans::DoStop() - enter\n");
		erouter->forgetListener(this);
		count=0;
		Transition::DoStop();
		//serr->printf("VisualTargetTrans::DoStop() - leave\n");
	}

	//!if the object is "close", calls activate()
	virtual void processEvent(const EventBase& e) {
		//serr->printf("VisualTargetTrans::processEvent() - enter %d\n",get_time());

		if(e.getTypeID()==EventBase::deactivateETID)
			count=0;
		else
			count++;
		if(count>5)
			activate();

		//serr->printf("VisualTargetTrans::processEvent() - leave %d\n",get_time());
	}

	virtual std::string getName() const { return "VisualTargetTrans"; }

protected:
	//!Source ID of object to track
	unsigned int sid;
	//! number of frames for which we've seen the object
	unsigned int count;
};

/*! @file
 * @brief Defines VisualTargetTrans, which causes a transition when a visual object is seen for a few frames
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_1 $
 * $Revision: 1.9 $
 * $State: Exp $
 * $Date: 2003/12/08 00:21:02 $
 */

#endif
