#include "Transition.h"
#include "StateNode.h"
#include "Wireless/Wireless.h"
#include "SoundPlay/SoundManager.h"

void Transition::activate() {
	//serr->printf("%s activate() - enter %d\n",getName().c_str(),get_time());

	AddReference(); //just in case a side effect of this transition is to dereference the transition, we don't want to be deleted while still transitioning

	if(sound.size()!=0)
		sndman->PlayFile(sound.c_str());

	for(unsigned int i=0; i<srcs.size(); i++)
		if(srcs[i]->isActive()) //It's usually a bad idea to call DoStop/DoStart when it's already stopped/started...
			srcs[i]->DoStop();
	for(unsigned int i=0; i<dsts.size(); i++)
		if(!dsts[i]->isActive())
			dsts[i]->DoStart();

	//serr->printf("%s activate() - leave %d\n",getName().c_str(),get_time());
	RemoveReference();
}

/*! @file
 * @brief Implements Transition, represents a transition between StateNodes.
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_1 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2003/11/11 00:08:10 $
 */

