//-*-c++-*-
#ifndef INCLUDED_GroupNode_h_
#define INCLUDED_GroupNode_h_

#include "Behaviors/StateNode.h"
#include <vector>

//! Allows a group of StateNodes to be activated together
/*! When a transition occurs into the group node, it will activate all
 *	of its subnodes.
 *
 *  Note that this doesn't occur if there's a transition to one of the
 *  sub nodes...  only when the main group node itself transitions.
 *
 *  The group node doesn't deactivate its subnodes together however.
 *  In essence, this is a fork - one transition can activate several
 *  states, which are then separate branches of execution.  (Although
 *  only one is actually being executed at a time)
 */
class GroupNode : public StateNode {
public:
	//!constructor
	GroupNode() : StateNode("GroupNode") {}
	//!constructor
	explicit GroupNode(const std::string& nm, StateNode* p=NULL) : StateNode(nm,p) {}

	//! activates all of the sub nodes
	virtual void DoStart() {
		StateNode::DoStart();
		for(std::vector<StateNode*>::iterator it=nodes.begin(); it!=nodes.end(); it++)
			if(!(*it)->isActive())
				(*it)->DoStart();
	}
	
private:
	GroupNode(const GroupNode& node); //!< don't call this
	GroupNode operator=(const GroupNode& node); //!< don't call this
};

/*! @file
 * @brief Defines GroupNode, which allows a group of StateNodes to be activated together
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:57 $
 */

#endif
