function stabilize1(path, outpath)
% Performs image stabilization on images in directory indicated by path.
% Attempts only to correct for rotation, scaling, and skew.

% Get list of PNG files in path. The dir function will sort them by
% keyframe number.
Pngs = dir([path '/*.png']);

% Load the first image in the sequence
im1 = imread([path '/' Pngs(1).name]);
% Isolate a single channel and convert it to doubles
im1 = double(im1(:,:,1));
% Show im1
figure;
subplot(1,2,1); colormap gray; imagesc(im1); axis equal;
subplot(1,2,2); colormap gray; imagesc(im1); axis equal; drawnow;
pause

% Initialize the homography we're computing throughout the sequence to I
H = eye(3);

% Loop through all the remaining images
for png = Pngs(2:length(Pngs))'
  % Load current image. Same procedure as before
  im2 = imread([path '/' png.name]); im2 = double(im2(:,:,1));

  % Compute H matrix between both images. Note that we don't carry over
  % the scaled image from before--we just multiply this H with the
  % H we're carrying through the whole sequence. By doing this, we
  % avoid image degradation problems that come from warping
  local_H = ransacH(im2, im1);
  H = H*local_H;

  % Scale H to avoid numerical instability.
  H = H / H(3,3);

  % Now show the warped image
  Iwarp = warpImage(im2,H);
  subplot(1,2,1); colormap gray; imagesc(im2); axis equal;
  subplot(1,2,2); colormap gray; imagesc(Iwarp); axis equal; drawnow;

  % Stash im2 in im1 for the next iteration
  im1 = im2;
end
