function H=computeH(pees, cues)
% Does problem 1.3
%
% Points must be the columns in pees and cues. You must have the same number
% of points in both matrices.

% Step 1: Multiply the pees and cues by 0.01 to avoid numerical instability
pees = pees .* 0.01;
cues = cues .* 0.01;

% Turn pees into homogeneous coordinates.
pdim = size(pees);
pees = [ pees ; ones(1, pdim(2)) ];

% Make cues into a straight vector like this: [ u1 ; v1 ; u2 ; v2 ... un ; vn ]
cues = reshape(cues,1,numel(cues))';

% Make a matrix like this: [ p1' ; p1' ; p2' ; p2' ... pn' ; pn' ]
pstack = reshape([pees ; pees], 3, pdim(2)*2)';

% Construct a matrix which we will multiply element by element with copies
% of pstack to get the U matrix
upre = [repmat([1 1 1 0 0 0; 0 0 0 1 1 1], pdim(2), 1) cues cues cues];

% Make the U matrix at last
U = upre .* [ -pstack -pstack pstack ];

% Find the eigenvalues of U'*U, also known as W
[vects, vals] = eig(U'*U);

% Find the smallest eigenvalue from above
[tiny, index] = min(diag(vals));

% Return final H
H = reshape(vects(:,index),3,3)';
