#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"
#include "Behaviors/Controls/BehaviorSwitchControl.h"

#include "Behaviors/Demos/AlanBehavior.h"
#include "Behaviors/Demos/ChaseBallBehavior.h"
#include "Behaviors/Demos/SimpleChaseBallBehavior.h"
#include "Behaviors/Demos/StareAtBallBehavior.h"
#include "Behaviors/Demos/FollowHeadBehavior.h"
#include "Behaviors/Demos/WalkToTargetMachine.h"
#include "Behaviors/Demos/BanditMachine.h"
#include "Behaviors/Demos/SoundTestBehavior.h"
#include "Behaviors/Demos/ExploreMachine.h"
#include "Behaviors/Demos/PaceTargetsMachine.h"

#include "Shared/ProjectInterface.h"

ControlBase*
StartupBehavior::SetupModeSwitch() {
	addItem(new ControlBase("Mode Switch","Contains the \"major\" applications - mutually exclusive selection"));
	startSubMenu();
	{
		//this group allows the behaviors to turn each other off when you start a new one so
		//only one is running at a time - like radio buttons
		BehaviorSwitchControlBase::BehaviorGroup * bg = new BehaviorSwitchControlBase::BehaviorGroup();

		//put behaviors here:
		if(state->robotDesign&WorldState::ERS210Mask) //this one only really works on the 210
			addItem(new BehaviorSwitchControl<AlanBehavior>("AlanBehavior",bg,false));
		addItem(new BehaviorSwitchControl<FollowHeadBehavior>("FollowHeadBehavior",bg,false));
		addItem(new BehaviorSwitchControl<SoundTestBehavior>("SoundTestBehavior",bg,false));
		addItem(new BehaviorSwitchControl<ChaseBallBehavior>("ChaseBallBehavior",bg,false));
		addItem(new BehaviorSwitchControl<SimpleChaseBallBehavior>("SimpleChaseBallBehavior",bg,false));
		addItem(new BehaviorSwitchControl<StareAtBallBehavior>("StareAtBallBehavior",bg,false));
		addItem(new BehaviorSwitchControlBase(new WalkToTargetMachine(ProjectInterface::visPinkBallSID),bg));
		addItem(new BehaviorSwitchControl<BanditMachine>("BanditMachine",bg,false));
		addItem(new BehaviorSwitchControl<ExploreMachine>("ExploreMachine",bg,false));
		addItem(new BehaviorSwitchControl<PaceTargetsMachine>("PaceTargetsMachine",bg,false));
	}
	return endSubMenu();
}

