/*
 * Inserted into code with the motion parameters dx, dy, da, and time,
 * this routine changes them to reflect actual motion data gathered
 * from the AIBO. A kludge.
 */
/*
   Forward motion regression data for forward motion at 180:

b = -32.0347
    162.5885

bint = -50.9954  -13.0740
       160.2251  164.9518


   Left turn motion regression data for left turns at 1.008 (or 1.0236)

b = -28.3579
     69.3368

bint = -32.3540  -24.3618
        67.5766   71.0971


    Right turn motion regression data for right turns at 1.008

b = -34.7600
     68.4120

bint = -39.0989  -30.4211
        66.5712   70.2528

 */

  /* FIXME -- needs to not be tacked on -- FIXME */

  /* Based on the above regression data, we tune the AIBO walk parameters to
   * be more in accordance with actual motion. The data are too limited to
   * model even a narrow range of the AIBO's walking (indeed, sidestepping,
   * which is hideously inaccurate, is not even modeled at all! We try to
   * reason about the full range of AIBO's motion below, but for motion
   * parameters outside of those tested above, everything is purely
   * speculative. Let the pondering begin!
   *
   * One thing that is certain is that the AIBO's walk doesn't move the
   * dog anywhere until the walk parameters are above a certain value.
   * We can surmise that a good part of the x-intercept for forward motion
   * has to do with this phenomenon, since the robot has to accelerate up
   * to speed and decelerate to stop (linearly, thank heavens).
   *
   * Empirically, this minimum threshold for forward motion comes at about
   * 55. For turning left, it's about 0.2. For turning right, it's also
   * about 0.2. So, to achieve verisimilitude in our motion model, we'll
   * scale all the motion commands accordingly and hope for the best. We
   * don't have any motion data to find the x intercept for forward speed
   * other than 180 or rotational speeds other than 1, so I guess we'll just
   * guess. */
#define RESCALE_DX_A	162.5885
#define RESCALE_DX_B	-32.0347
#define DX_MOT_THRESH	55

#define RESCALE_DA_LEFT_A	69.3368*M_PI/180
#define RESCALE_DA_LEFT_B	-28.3579*M_PI/180
#define DA_LEFT_MOT_THRESH	0.2

#define RESCALE_DA_RIGHT_A	-68.4120*M_PI/180
#define RESCALE_DA_RIGHT_B	34.7600*M_PI/180
#define DA_RIGHT_MOT_THRESH	-0.2

/* First we rescale dx and da */
if(dx > DX_MOT_THRESH)
  dx = RESCALE_DX_A * (dx - DX_MOT_THRESH) / (180.0 - DX_MOT_THRESH);
else if(dx < -DX_MOT_THRESH)
  dx = RESCALE_DX_A * (dx + DX_MOT_THRESH) / (180.0 - DX_MOT_THRESH);
else dx = 0.0;

if(da > DA_LEFT_MOT_THRESH)
  da = RESCALE_DA_LEFT_A *
	(da - DA_LEFT_MOT_THRESH) / (1.008 - DA_LEFT_MOT_THRESH);
else if(da < DA_RIGHT_MOT_THRESH)
  da = RESCALE_DA_RIGHT_A *
	(da - DA_RIGHT_MOT_THRESH) / (1.008 - DA_RIGHT_MOT_THRESH);
else da = 0.0;

  /* Now, what to do about that X intercept... Since we don't have access to
   * the motion model from here (so, strictly speaking, all this tweaking is
   * illegitimate, but whatever), we can't tell it to reduce its final
   * estimates of forward or rotational motion by a certain amount. What we
   * can do, though, is reduce the amount of transit time passed to the
   * motion model.
   *
   * Moving forward, the robot "accelerates" at 162.6 * 3.8 = 617.8 "mm"/s^2.
   * This means it reaches the magic forward motion threshold of 55 "mm"/s
   * in 0.09 seconds. Likewise, rotating, it "accelerates" at 3.6 "rad"/s^2.
   * That means it reaches the threshold of 0.2 "rad"/s in 0.05 s. Since we
   * can only alter time one way, the strategy here is to lop off 0.09*2
   * seconds when going forward, 0.05*2 seconds when going sideways, and
   * 0.07 seconds otherwise. KLUUUUUUUUUDGEEE! */
     if((dx != 0.0) && (da == 0.0)) time = (time > 180 ? time - 180 : 0);
else if((dx == 0.0) && (da != 0.0)) time = (time > 100 ? time - 100 : 0);
else time = (time > 140 ? time - 140 : time = 0);
