#include "EvtRptBehavior.h"
#include "Events/EventRouter.h"
#include "Events/VisionObjectEvent.h"
#include "Events/LocomotionEvent.h"
#include "Shared/ProjectInterface.h"

void EvtRptBehavior::DoStart() {
	BehaviorBase::DoStart();
	erouter->addListener(this,EventBase::locomotionEGID);
	erouter->addListener(this,EventBase::visObjEGID);
}

void EvtRptBehavior::DoStop() {
	erouter->forgetListener(this);
	BehaviorBase::DoStop();
}

//this could be cleaned up event-wise (only use a timer when out of view)
void EvtRptBehavior::processEvent(const EventBase& event) {
	if(event.getGeneratorID() == EventBase::visObjEGID && event.getTypeID() == EventBase::statusETID) {
		if(event.getSourceID() == ProjectInterface::visBlueBallSID)
			std::cout << "BLUE ball seen";
		else if(event.getSourceID()==ProjectInterface::visPinkBallSID)
			std::cout << "PINK ball seen";
		else if(event.getSourceID()==ProjectInterface::visHandSID)
			std::cout << "HAND seen";
		else
			std::cout << "something else seen (sid==" << event.getSourceID() << ")";
		
		if(const VisionObjectEvent * visevt=dynamic_cast<const VisionObjectEvent*>(&event)) {
			float horiz = visevt->getCenterX();
			float vert  = visevt->getCenterY();
			std::cout << " at h=" << horiz << " v=" << vert << std::endl;
		} else {
			std::cout << "weird: event from visObjEGID is not VisionObjectEvent" << std::endl;
		}
	} else if(event.getGeneratorID() == EventBase::locomotionEGID && event.getTypeID() == EventBase::statusETID) {
		if(const LocomotionEvent * locoevt=dynamic_cast<const LocomotionEvent*>(&event)) {
			float x = locoevt->x;
			float y = locoevt->y;
			float a = locoevt->a;
			std::cout << "MOTION dx=" << x << " dy=" << y << " da=" << a << std::endl;
		} else {
			std::cout << "weird: event from locomotionEGID is not LocomotionEvent" << std::endl;
		}
	}
}
			
/*! @file
 * @brief Implements EvtRptBehavior, which std::couts information about events it sees
 * @author tss (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/12/14 00:23:54 $
 */


