import javax.swing.JPanel;
import java.awt.image.BufferedImage;
import java.awt.Graphics;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;

public class VisionPanel extends JPanel implements VisionUpdatedListener {
    BufferedImage _image;
    VisionListener _listener;
    boolean lockAspect=false;
    static float defAspectRatio=176/(float)144;
    float tgtAspect=defAspectRatio;
    
    protected VisionPanel(VisionListener listener) {
	_listener=listener;
	_listener.addListener(this);
	setBackground(Color.BLACK);
	setForeground(Color.WHITE);
	setOpaque(!lockAspect);
    }
    
    public VisionListener getListener() { return _listener; }
    
    public void close() {
	_listener.kill();
    }
    
    public void open() {
	_listener.startThread();
    }
    
    public void visionUpdated(VisionListener l) {
	repaint();
    }
    
    public void setLockAspectRatio(boolean b) {
	if(b!=lockAspect) {
	    lockAspect=b;
	    setOpaque(!lockAspect);
	    repaint();
	}
    }
    
    public boolean getLockAspectRatio() { return lockAspect; }
    
    public void setAspectRatio(float asp) {
	if(asp<=0)
	    tgtAspect=defAspectRatio;
	else
	    tgtAspect=asp;
	if(getLockAspectRatio())
	    repaint();
    }
    
    public float getAspectRatio() { return tgtAspect; }
    
    public void setLockAspectRatio(boolean b, float asp) {
	setLockAspectRatio(b);
	setAspectRatio(asp);
    }
    
    public void paint(Graphics graphics) {
	_image=_listener.getImage();
	super.paint(graphics);
	Dimension sz=getSize();
	if(getLockAspectRatio()) {
	    float curasp=sz.width/(float)sz.height;
	    float tgtasp=getAspectRatio();
	    if(curasp>tgtasp) {
		int width=(int)(sz.height*tgtasp);
		drawImage(graphics,_image, (sz.width-width)/2, 0, width, sz.height);
	    } else if(curasp<tgtasp) {
		int height=(int)(sz.width/tgtasp);
		drawImage(graphics,_image, 0, (sz.height-height)/2, sz.width, height);
	    } else {
		drawImage(graphics,_image, 0, 0, sz.width, sz.height);
	    }
	} else
	    drawImage(graphics,_image, 0, 0, sz.width, sz.height);
    }
    
    protected void drawImage(Graphics g, BufferedImage img, int x, int y, int w, int h) {
	if(img!=null)
	    g.drawImage(img,x,y,w,h,null);
	else {
	    g.setColor(getBackground());
	    g.fillRect(x,y,w,h);
	    FontMetrics tmp=g.getFontMetrics();
	    String msg="No image";
	    int strw=tmp.stringWidth(msg);
	    int strh=tmp.getHeight();
	    g.setColor(getForeground());
	    g.drawString(msg,(getSize().width-strw)/2,(getSize().height-strh)/2+tmp.getAscent());
	}
    }
}
