//-*-c++-*-
#ifndef INCLUDED_SampleMC_h_
#define INCLUDED_SampleMC_h_

#include "Shared/WorldState.h"
#include "Motion/MotionCommand.h"
#include "Motion/MotionManager.h"

//!a simple MotionCommand which mirrors the legs
class SampleMC : public MotionCommand {
public:
	// Constructor
	SampleMC() : MotionCommand(), source(0) {
		// by default, mirror the dog's left front leg
		setSource(LFrLegOrder);
	}

	// Abstract functions:
	// These must be defined by every MotionCommand
	virtual int updateOutputs() {
		//get current position of the source leg
		for(unsigned int i=0; i<NumLegJoints; i++) {
			unsigned int joint=i%JointsPerLeg;
			float source_pos=state->outputs[source+joint];
			motman->setOutput(this,LegOffset+i,source_pos);
		}
		//zeros for the PID value 'turn off' the joint
		float offpid[3]={0,0,0};
		for(unsigned int i=0; i<JointsPerLeg; i++)
			motman->setOutput(this,source+i,offpid);
		//by convention, return the number of dirty joints (or 1 if unknown)
		return NumLegJoints;
	}
	virtual int isDirty() {
		//just assume the source leg is always
		//moving, so we're always dirty
		return true;
	}
	virtual int isAlive() {
		//there's not really an 'end condition' for this
		//motion, so we're always alive
		return true;
	}

	// "Local" Functions:
	// These provide customization to the task at hand (paw?)
	virtual void setSource(LegOrder_t leg) {
		source=leg*JointsPerLeg+LegOffset;
	}
	virtual LegOrder_t getSource() {
		return static_cast<LegOrder_t>((source-LegOffset)/JointsPerLeg);
	}

protected:
	unsigned int source;               /* the joint offset of the leg to mirror */
};

/*! @file
 * @brief Defines the SampleMC, a simple MotionCommand which mirrors the legs
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.1 $
 * $State: Rel $
 * $Date: 2003/08/01 17:54:26 $
 */

#endif
