#include "InterleavedYUVGenerator.h"
#include "Events/EventRouter.h"
#include "Events/FilterBankEvent.h"
#include "Wireless/Wireless.h"
#include "Shared/WorldState.h"

#include "Shared/debuget.h"

InterleavedYUVGenerator::InterleavedYUVGenerator(EventBase::EventGeneratorID_t gid, unsigned int sid, unsigned int mysid)
	: FilterBankGenerator("InterleavedYUVGenerator",0,1,gid,sid,EventBase::visInterleaveEGID,mysid), src(NULL), srcYChan(0), srcUChan(1), srcVChan(2)
{
	setNumImages(numLayers,numChannels);
}

InterleavedYUVGenerator::InterleavedYUVGenerator(EventBase::EventGeneratorID_t gid, unsigned int sid, unsigned int mysid, unsigned int syc, unsigned int suc, unsigned int svc)
	: FilterBankGenerator("InterleavedYUVGenerator",0,1,gid,sid,EventBase::visInterleaveEGID,mysid), src(NULL), srcYChan(syc), srcUChan(suc), srcVChan(svc)
{
	setNumImages(numLayers,numChannels);
}

/*
InterleavedYUVGenerator::~InterleavedYUVGenerator() {
	freeCaches();
	destruct();
}
*/

void
InterleavedYUVGenerator::processEvent(const EventBase& event) {
	const FilterBankEvent& fbkevent=dynamic_cast<const FilterBankEvent& >(event);
	src=fbkevent.getSource();
	frameNumber=src->getFrameNumber();
	if(src->getNumLayers()!=numLayers || src->getNumChannels()!=numChannels)
		setNumImages(src->getNumLayers(),1);
	if(src->getWidth(numLayers-1)!=getWidth(numLayers-1)) {
		ASSERT(widths[numLayers-1]==0,"Strange, the image width changed after initial setting" << widths[numLayers-1]);
		setDimensions();
	}

	invalidateCaches();
	framesProcessed++;
	erouter->postEvent(new FilterBankEvent(this,getGeneratorID(),getSourceID()));
}

unsigned int
InterleavedYUVGenerator::getBinSize() const {
	unsigned int used=FilterBankGenerator::getBinSize();
	used+=strlen("InterleavedYUVImage")+LoadSave::stringpad;
	//if(selectedSaveChannel==CHAN_YUV)
	used+=widths[selectedSaveLayer]*heights[selectedSaveLayer]*3;
	//else
	//used+=widths[selectedSaveLayer]*heights[selectedSaveLayer];
	return used;
}

unsigned int
InterleavedYUVGenerator::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used;
	std::string tmp;
	if(0==(used=FilterBankGenerator::LoadBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(tmp,buf,len))) return 0;
	len-=used; buf+=used;
	if(tmp!="InterleavedYUVImage") {
		serr->printf("Unhandled image type for InterleavedYUVGenerator: %s",tmp.c_str());
		return 0;
	} else {
		//if(selectedSaveChannel==CHAN_YUV) {
		used=widths[selectedSaveLayer]*heights[selectedSaveLayer]*3;
		if(used>len)
			return 0;
		if(images[selectedSaveLayer][selectedSaveChannel]==NULL)
			images[selectedSaveLayer][selectedSaveChannel]=createImageCache(selectedSaveLayer,selectedSaveChannel);
		unsigned char* img=images[selectedSaveLayer][selectedSaveChannel];
		if(img==NULL)
			return 0;
		memcpy(img,buf,used);
		len-=used; buf+=used;
		imageValids[selectedSaveLayer][selectedSaveChannel]=true;
		/*
		} else {
			used=widths[selectedSaveLayer]*heights[selectedSaveLayer];
			if(used>len)
				return 0;
			unsigned char* img=getImage(selectedSaveLayer,selectedSaveChannel);
			if(img==NULL)
				return 0;
			unsigned int inc=getIncrement(selectedSaveLayer);
			for(unsigned int y=0; y<heights[selectedSaveLayer]; y++) {
				unsigned char* const rowend=img+widths[selectedSaveLayer]*inc;
				while(img!=rowend) {
					*img=*buf++;
					img+=inc;
				}
				img+=getSkip(selectedSaveLayer);
			}
			len-=used; buf+=used;
		}
		*/
		return origlen-len;	
	}
}

unsigned int
InterleavedYUVGenerator::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=FilterBankGenerator::SaveBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode("InterleavedYUVImage",buf,len))) return 0;
	len-=used; buf+=used;
	
	//if(selectedSaveChannel==CHAN_YUV) {
	used=widths[selectedSaveLayer]*heights[selectedSaveLayer]*3;
	if(used>len)
		return 0;
	unsigned char* img=getImage(selectedSaveLayer,selectedSaveChannel);
	if(img==NULL)
		return 0;
	memcpy(buf,img,used);
	len-=used;
	/*
	} else {
		used=widths[selectedSaveLayer]*heights[selectedSaveLayer];
		if(used>len)
			return 0;
		unsigned char* img=getImage(selectedSaveLayer,selectedSaveChannel);
		if(img==NULL)
			return 0;
		unsigned int inc=getIncrement(selectedSaveLayer);
		for(unsigned int y=0; y<heights[selectedSaveLayer]; y++) {
			unsigned char* const rowend=img+widths[selectedSaveLayer]*inc;
			while(img!=rowend) {
				*buf++=*img;
				img+=inc;
			}
			img+=getSkip(selectedSaveLayer);
		}
		len-=used; buf+=used;
	}
	*/
	return origlen-len;
}

/*
void 
InterleavedYUVGenerator::freeCaches() {
	for(unsigned int i=0; i<numLayers; i++) {
		for(unsigned int j=0; j<numChannels-1; j++) {
			images[i][j]=NULL;
			imageValids[i][j]=false;
		}
	}
	FilterBankGenerator::freeCaches();
}
*/

void
InterleavedYUVGenerator::setDimensions() {
	for(unsigned int i=0; i<numLayers; i++) {
		widths[i]=src->getWidth(i);
		heights[i]=src->getHeight(i);
		skips[i]=0;
		strides[i]=widths[i]*3;
	}	
}

void
InterleavedYUVGenerator::setNumImages(unsigned int nLayers, unsigned int nChannels) {
	ASSERT(nChannels==1,"we can only handle a single channel...");
	FilterBankGenerator::setNumImages(nLayers,nChannels);
	for(unsigned int res=0; res<numLayers; res++)
		increments[res]=3;
}

/*
unsigned char *
InterleavedYUVGenerator::createImageCache(unsigned int layer, unsigned int chan) const {
	unsigned char* yuv=new unsigned char[widths[layer]*heights[layer]*3];
	for(unsigned int i=0; i<numChannels-1; i++) {
		ASSERT(images[layer][i]==NULL,"memory leak?");
		images[layer][i]=yuv+i;
	}
	ASSERT(images[layer][CHAN_YUV]==NULL,"memory leak?");
	images[layer][CHAN_YUV]=yuv;
	if(chan==CHAN_YUV) {
		return yuv;
	} else {
		return yuv+chan;
	}
}
*/

unsigned char *
InterleavedYUVGenerator::createImageCache(unsigned int layer, unsigned int /*chan*/) const {
	return new unsigned char[widths[layer]*heights[layer]*3];
}

void
InterleavedYUVGenerator::calcImage(unsigned int layer, unsigned int chan) const {
	PROFSECTION("InterleavedYUVGenerator::calcImage(...)",state->mainProfile);
	unsigned char* dimg=images[layer][chan];
	const unsigned char* syimg=src->getImage(layer,srcYChan);
	const unsigned char* suimg=src->getImage(layer,srcUChan);
	const unsigned char* svimg=src->getImage(layer,srcVChan);
	const unsigned int inc=src->getIncrement(layer);
	//std::cout << src->getWidth(layer) << " inc=" << inc << " skip=" << src->getSkip(layer) << " stride=" << src->getStride(layer) << std::endl;
	for(unsigned int y=0; y<getHeight(layer); y++) {
		for(unsigned int x=0; x<getWidth(layer); x++) {
			*dimg++=*syimg;
			*dimg++=*svimg;
			*dimg++=*suimg;
			syimg+=inc;
			suimg+=inc;
			svimg+=inc;
		}
		syimg+=src->getSkip(layer);
		suimg+=src->getSkip(layer);
		svimg+=src->getSkip(layer);
	}
	imageValids[layer][chan]=true;
}

/*! @file
 * @brief Implements InterleavedYUVGenerator, which generates FilterBankEvents containing raw camera images with interleaved pixels (YUVYUVYUV... instead of YYY...UUU...VVV...)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.7 $
 * $State: Exp $
 * $Date: 2004/01/16 07:39:50 $
 */

