//-*-c++-*-
#ifndef INCLUDED_RobotInfo_h
#define INCLUDED_RobotInfo_h

#if TGT_ERS220
#	include "ERS220Info.h"
#elif TGT_ERS210
#	include "ERS210Info.h"
#elif TGT_ERS7
#	include "ERS7Info.h"
#else //default case, ERS2xx
#	if TGT_ERS2xx==0
#		warning "TGT_<model> undefined - defaulting to ERS2xx"
#	endif
#	include "ERS2xxInfo.h"
#endif //model selection

//! Contains information about the robot, such as number of joints, PID defaults, timing information, etc.
/*! This is just a wrapper for whichever namespace corresponds to the current
 *  robot target setting (one of TGT_ERS210, TGT_ERS220, TGT_ERS7, or the default, TGT_ERS2xx)
 *
 *  You probably should look at ERS210Info, ERS220Info, or ERS2xxInfo for the actual
 *  constants used for each model. */
namespace RobotInfo {

#if TGT_ERS220
	using namespace ERS220Info;
#elif TGT_ERS210
	using namespace ERS210Info;
#elif TGT_ERS7
	using namespace ERS7Info;
#else //default case, ERS2xx
	using namespace ERS2xxInfo;
#endif //model selection	
}

using namespace RobotInfo;
	
/*! @file
 * @brief Checks the define's to load the appropriate header and namespace
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.14 $
 * $State: Exp $
 * $Date: 2003/12/23 06:33:43 $
 */

#endif
