//-*-c++-*-
#ifndef INCLUDED_MotionManagerMsg_h
#define INCLUDED_MotionManagerMsg_h

//! A small header that preceeds data sent by MotionManager between processes
struct MotionManagerMsg {
	//! the type to use when referring to MotionCommand ID's
	typedef unsigned short MC_ID;

	//! for errors and undefined stuff
	static const MC_ID invalid_MC_ID=static_cast<MC_ID>(-1); 

	//! constructor
	MotionManagerMsg() : type(unknown), mc_id(invalid_MC_ID) {}

	//! virtual destructor
	/*! doesn't do anything, but don't remove it, otherwise this would no longer be a virtual base class */
	virtual ~MotionManagerMsg() {}

	//! Accessor for the id number, set by MotionManager::addMotion()
	MC_ID getID() const { return mc_id; }

protected:
	//! resets the #mc_id to #invalid_MC_ID
	void clearID() { mc_id=invalid_MC_ID; }

private:
	friend class MotionManager;

	//! Denotes what type of message this is
	enum MsgType { addMotion, deleteMotion, unknown } type;
	
	//! The id of the MotionCommand this is in reference to
	MC_ID mc_id;

	//! Sets up the header as an add motion message
	void setAdd(MC_ID id) {
		type=addMotion;
		mc_id=id;
	}

	//! Sets up the header as an erase motion message
	void setDelete(MC_ID id) {
		type=deleteMotion;
		mc_id=id;
	}

};

/*! @file
 * @brief Defines MotionManagerMsg, a small header used by MotionManager for sending messages between processes
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.4 $
 * $State: Rel $
 * $Date: 2003/09/02 20:58:49 $
 */

#endif // INCLUDED_MotionManagerMsg_h
