//-*-c++-*-
#ifndef INCLUDED_VisionObjectEvent_h
#define INCLUDED_VisionObjectEvent_h

#include "EventBase.h"

//! Extends EventBase to also include location in the visual field and distance (though distance is not implimented yet)
class VisionObjectEvent : public EventBase {
 public:
	//! Constructor
  VisionObjectEvent() : EventBase(EventBase::visObjEGID,(unsigned int)-1,EventBase::statusETID,0),_cenX(0),_cenY(0),_distance()/*,_property(-1)*/ {}
	//! Constructor, pass a type id and source id
  VisionObjectEvent(EventTypeID_t tid, unsigned int sid) : EventBase(EventBase::visObjEGID,sid,tid,0),_cenX(0),_cenY(0),_distance()/*,_property(-1)*/ {}
	//! Constructor, pass the type id, source id, center X and center Y
  VisionObjectEvent(EventTypeID_t tid, unsigned int sid, float cenX, float cenY) : EventBase(EventBase::visObjEGID,sid,tid,0),_cenX(cenX),_cenY(cenY),_distance()/*,_property(-1)*/ {}
	//! destructor
	virtual ~VisionObjectEvent() {}
  
  float getCenterX() const { return _cenX;} //!< returns the x coordinate
  VisionObjectEvent& setCenterX(float cenX) { _cenX=cenX; return *this;} //!< sets the x coordinate
  
  float getCenterY() const { return _cenY;} //!< returns the y coordinate
  VisionObjectEvent& setCenterY(float cenY) { _cenY=cenY; return *this;} //!< sets the y coordinate

  float getDistance() const { return _distance;} //!< returns the distance (not implemented)
  VisionObjectEvent& setDistance(float dist) { _distance=dist; return *this;} //!< sets the distance

  //int getProperty() const { return _property;} //!< returns the property (for future use)
  //VisionObjectEvent& setProperty(int property) { _property=property; return *this;} //!< sets the property
      
	virtual unsigned int getBinSize() const;
	virtual unsigned int LoadBuffer(const char buf[], unsigned int len);
	virtual unsigned int SaveBuffer(char buf[], unsigned int len) const;

 protected:
	float _cenX; //!< a value representing location in visual field - from -1 if on the left edge to 1 if it's on the right edge
	float _cenY; //!< a value representing location in visual field - from -1 if on the bottom edge to 1 if it's on the top edge
	float _distance; //!< distance from snout to object in millimeters. (not implemented)
  //int _property; //!< some property, depending on the SID (for future use)
};

/*! @file
 * @brief Provides information about objects recognized in the camera image
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2003/12/08 00:21:05 $
 */

#endif
