//-*-c++-*-
#ifndef INCLUDED_SegCamBehavior_h_
#define INCLUDED_SegCamBehavior_h_

#include "Behaviors/BehaviorBase.h"

class Socket;
class FilterBankGenerator;
class FilterBankEvent;

//! Forwards segmented images from camera over wireless
class SegCamBehavior : public BehaviorBase {
public:
	//! constructor
	SegCamBehavior();

	static const unsigned int WIRELESS_BUFFER_SIZE=85000; //!< 85000 bytes for use up to 416x320 pixels / 8 min expected runs * 5 bytes per run + some padding

	virtual void DoStart();

	virtual void DoStop();

	virtual void processEvent(const EventBase& e);

	virtual std::string getName() const { return "SegCamServer"; }

	static std::string getClassDescription() { return "Forwards segmented images from camera over wireless"; }
	
protected:
	bool openPacket(FilterBankGenerator& fbkgen, unsigned int time, unsigned int layer); //!< opens a new packet, writes header info; returns true if open, false if otherwise open (check cur==NULL for error)
	bool writeRLE(const FilterBankEvent& fbke); //!< writes a color image
	bool writeSeg(const FilterBankEvent& fbke); //!< writes a color image
	void closePacket(); //!< closes and sends a packet, does nothing if no packet open

	Socket * visRLE; //!< socket to send image stream over
	char * packet; //!< buffer being filled out to be sent
	char * cur; //!< current location in #packet
	unsigned int avail; //!< number of bytes remaining in #packet

private:
	SegCamBehavior(const SegCamBehavior&); //!< don't call
	SegCamBehavior& operator=(const SegCamBehavior&); //!< don't call
};

/*! @file
 * @brief Describes SegCamBehavior, which forwards segmented images from camera over wireless
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.3 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:57 $
 */

#endif
