//-*-c++-*-
#ifndef INCLUDED_RawCamBehavior_h_
#define INCLUDED_RawCamBehavior_h_

#include "Behaviors/BehaviorBase.h"

class Socket;
class FilterBankGenerator;
class FilterBankEvent;

//! Forwards images from camera over wireless
class RawCamBehavior : public BehaviorBase {
public:
	//! constructor
	RawCamBehavior();

	static const unsigned int WIRELESS_BUFFER_SIZE=200000; //!< 200000 bytes for use up to 416x320 + 2*208x160 (double res Y, full res UV on ERS-7)

	virtual void DoStart();

	virtual void DoStop();

	virtual void processEvent(const EventBase& e);

	virtual std::string getName() const { return "RawCamServer"; }

	static std::string getClassDescription() { return "Forwards images from camera over wireless"; }
	
protected:
	bool openPacket(FilterBankGenerator& fbkgen, unsigned int time, unsigned int layer); //!< opens a new packet, writes header info; returns true if open, false if otherwise open (check cur==NULL for error)
	bool writeColor(const FilterBankEvent& fbke); //!< writes a color image
	bool writeSingleChannel(const FilterBankEvent& fbke); //!< writes a single channel
	void closePacket(); //!< closes and sends a packet, does nothing if no packet open

	Socket * visRaw; //!< socket for sending the image stream
	char * packet; //!< point to the current buffer being prepared to be sent
	char * cur; //!< current location within that buffer
	unsigned int avail; //!< the number of bytes remaining in the buffer

private:
	RawCamBehavior(const RawCamBehavior&); //!< don't call
	RawCamBehavior& operator=(const RawCamBehavior&); //!< don't call
};

/*! @file
 * @brief Describes RawCamBehavior, which forwards images from camera over wireless
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.6 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:57 $
 */

#endif
