//-*-c++-*-
#ifndef INCLUDED_WalkToTargetMachine_h_
#define INCLUDED_WalkToTargetMachine_h_

#include "Behaviors/StateNode.h"
#include "Behaviors/Transitions/TimeOutTrans.h"
#include "Behaviors/Transitions/VisualTargetCloseTrans.h"
#include "Motion/MotionManager.h"

//! a state machine for walking towards a visual target
class WalkToTargetMachine : public StateNode {
public:
	//!constructor, pass success (close), failure (lost), and parent nodes, and VisionObjectSourceID_t
	WalkToTargetMachine(unsigned int obj,StateNode* c=NULL, StateNode* l=NULL,StateNode* p=NULL)
		: StateNode("WalkToTarget",p),tracking(obj),timeout(NULL),closeTrans(NULL),close(c),lost(l),
			walker_id(MotionManager::invalid_MC_ID), headpointer_id(MotionManager::invalid_MC_ID) 
	{}
	
	virtual void setup();

	virtual void DoStart();
	virtual void DoStop();

	virtual void teardown();

	static std::string getClassDescription() { return "walks towards a visual target until it gets \"close\""; }

	//uses head to watch ball, walks towards it
	virtual void processEvent(const EventBase& event);
	
	virtual Transition* getLostTrans() { return timeout; } //!< returns the transition controlling "lost" designation
	virtual Transition* getCloseTrans() { return closeTrans; } //!< returns the transition controlling "close to target" designation


protected:
	unsigned int tracking; //!< the object being tracked
	TimeOutTrans* timeout; //!< transition in case we lose the target
	Transition* closeTrans; //!< transition in case we get close
	StateNode* close; //!< dest if we get close to the object
	StateNode* lost; //!< dest if we get lost
	MotionManager::MC_ID walker_id; //!< so we can walk
	MotionManager::MC_ID headpointer_id; //!< so we can point the head at the object

private:
	WalkToTargetMachine(const WalkToTargetMachine&); //!< don't call this
	WalkToTargetMachine operator=(const WalkToTargetMachine&); //!< don't call this
};

/*! @file
 * @brief Describes WalkToTargetMachine, a state machine for walking towards a visual target
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.11 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:56 $
 */

#endif
