//-*-c++-*-
#ifndef INCLUDED_MCRepeater_h_
#define INCLUDED_MCRepeater_h_

#include "Behaviors/BehaviorBase.h"
#include "Shared/SharedObject.h"
#include "Motion/MotionManager.h"
#include "Events/EventRouter.h"

//! Sends a given MotionCommand to MotionManager, waits until it autoprunes, and then sends it again.
class MCRepeater : public BehaviorBase {
public:
	//! constructor
	MCRepeater(const SharedObjectBase* sharedmc) : BehaviorBase(), mc(sharedmc) {}

	virtual void DoStart() {
		BehaviorBase::DoStart(); // do this first
		MotionManager::MC_ID id=motman->addMotion(*mc,true);
		erouter->addListener(this,EventBase::motmanEGID,id,EventBase::deactivateETID);
	}

	virtual void DoStop() {
		erouter->forgetListener(this);
		BehaviorBase::DoStop(); // do this last
	}

	virtual void processEvent(const EventBase& /*e*/) {
		erouter->forgetListener(this);
		MotionManager::MC_ID id=motman->addMotion(*mc,true);
		erouter->addListener(this,EventBase::motmanEGID,id,EventBase::deactivateETID);
	}

	virtual std::string getName() const { return "MCRepeater"; }

	static std::string getClassDescription() { return "Sends a given MotionCommand to MotionManager, waits until it autoprunes, and then sends it again."; }
	
protected:
	const SharedObjectBase* mc; //!< the motion command being repeated

private:
	MCRepeater(const MCRepeater&); //!< don't call
	MCRepeater operator=(const MCRepeater&); //!< don't call
};

/*! @file
 * @brief Defines MCRepeater, which sends a given MotionCommand to MotionManager, waits until it autoprunes, and then sends it again.
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:56 $
 */

#endif
