//-*-c++-*-
#ifndef INCLUDED_HelloWorldBehavior_h_
#define INCLUDED_HelloWorldBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Wireless/Wireless.h"

//! Demonstrates serr, sout, and cout
class HelloWorldBehavior : public BehaviorBase {
public:
	HelloWorldBehavior() : BehaviorBase()	{}
	
	virtual void DoStart() {
		//call superclass first for housekeeping:
		BehaviorBase::DoStart();

		//now do your code:
		for(unsigned int i=0; i<100; i++)
			serr->printf("Hello serr!  This is %d\n",i);
		for(unsigned int i=0; i<10; i++)
			sout->printf("Hello sout!  This is %d\n",i);
		for(unsigned int i=0; i<10; i++)
			cout << "Hello cout!  This is " << i << endl;
		for(unsigned int i=0; i<10; i++)
			printf("Hello printf!  This is %d\n",i);

		//we'll just stop right away since this Behavior has no 'active' state.
		DoStop();
	}
	
	virtual std::string getName() const {
		// Name is used for menus, or debugging.
		return "HelloWorldBehavior";
	}
	
	static std::string getClassDescription() {
		// This string will be shown by the HelpControl or by the tooltips of the Controller GUI
		return "A little demo of text output";
	}
	
};

/*! @file
 * @brief Defines HelloWorldBehavior, a little demo of text output (serr, sout, and cout)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.4 $
 * $State: Rel $
 * $Date: 2003/10/07 00:59:33 $
 */

#endif
