#include "SensorObserverControl.h"
#include "Events/EventRouter.h"
#include "Motion/MMAccessor.h"
#include "Motion/LedMC.h"
#include <sstream>
#include "Events/LocomotionEvent.h"
#include "Events/TextMsgEvent.h"
#include "Events/VisionObjectEvent.h"
#include "Shared/WorldState.h"

SensorObserverControl::SensorObserverControl()
	: ControlBase("Sensor Observer","Allows you to see/log the sensor data"), logfilePath(), logfile(), helpCtl(NULL), sensorCtl(NULL), buttonCtl(NULL), outputCtl(NULL), dutyCtl(NULL), consoleCtl(NULL), fileCtl(NULL), numListeners(0)
{
	const unsigned int TMP_LEN=64;
	char tmp[TMP_LEN];
	pushSlot(consoleCtl=new ToggleControl("Console Output","If selected, outputs events to the console"));
	pushSlot(fileCtl=new StringInputControl("[ ] File Output","Please enter the filename to log to (in /ms/...)"));
	pushSlot(helpCtl=new ControlBase("Help"));
	pushSlot(NULL);
	helpCtl->pushSlot(new NullControl("The indexes listed here"));
	helpCtl->pushSlot(new NullControl("correspond to offsets"));
	helpCtl->pushSlot(new NullControl("given in the __Info.h"));
	helpCtl->pushSlot(new NullControl("file for the model"));
	helpCtl->pushSlot(new NullControl("robot which you are "));
	helpCtl->pushSlot(new NullControl("currently using."));
	pushSlot(sensorCtl=new ControlBase("Sensors:","Toggles logging of various sensors"));
	for(unsigned int i=0; i<NumSensors; i++) {
		snprintf(tmp,TMP_LEN,"%d",i);
		sensorCtl->pushSlot(new ToggleControl(tmp,"Turns logging of this sensor on/off"));
	}
	pushSlot(buttonCtl=new ControlBase("Buttons:","Toggles logging of various buttons"));
	for(unsigned int i=0; i<NumButtons; i++) {
		snprintf(tmp,TMP_LEN,"%d",i);
		buttonCtl->pushSlot(new ToggleControl(tmp,"Turns logging of this button on/off"));
	}
	pushSlot(outputCtl=new ControlBase("Outputs:","Toggles logging of various outputs' positions"));
	for(unsigned int i=0; i<NumOutputs; i++)
		outputCtl->pushSlot(new ToggleControl(outputNames[i],"Turns logging of this output's values on/off"));
	pushSlot(dutyCtl=new ControlBase("Duties:","Toggles logging of various PID joint's duty cycles"));
	for(unsigned int i=0; i<NumPIDJoints; i++)
		dutyCtl->pushSlot(new ToggleControl(outputNames[i+PIDJointOffset],"Turns logging of how hard this output is working on/off"));
}

ControlBase* SensorObserverControl::doSelect() {
	ControlBase* ans=this;
	bool wasListening=(numListeners>0);
	for(unsigned int i=0; i<hilights.size(); i++) {
		unsigned int cur=hilights[i];
		if(options[cur]==fileCtl) {
			if(options[cur]->getName()[1]!=' ') {
				logfile.close();
				options[cur]->setName("[ ] File Output");
				numListeners--;
			} else {
				ans=options[cur];
				numListeners++;
			}
		} else if(options[cur]==consoleCtl) {
			options[cur]->doSelect();
			if(consoleCtl->getStatus())
				numListeners--;
			else
				numListeners++;
		} else { //(options[cur]==helpCtl || options[cur]==sensorCtl || options[cur]==buttonCtl || options[cur]==outputCtl || options[cur]==dutyCtl || options[cur]==consoleCtl)
			ans=options[cur];
		}
	}
	sndman->PlayFile(config->controller.select_snd);
	if(wasListening!=(numListeners>0)) {
		if(numListeners>0)
			erouter->addListener(this,EventBase::sensorEGID,0);
		else
			erouter->forgetListener(this);
	}
	if(ans==this)
		refresh();
	return ans;
}

void SensorObserverControl::refresh() {
	checkLogFile();
	ControlBase::refresh();
}

//!sends all events received to stdout and/or logfile
void SensorObserverControl::processEvent(const EventBase& /*event*/) {
	std::ostringstream logdata;
	for(unsigned int i=0; i<NumSensors; i++)
		if(ToggleControl * tgl=dynamic_cast<ToggleControl*>(sensorCtl->getSlots()[i]))
			if(tgl->getStatus())
				logdata << state->lastSensorUpdateTime << "\tSENSOR:\t" << i << '\t' << state->sensors[i] << '\n';
	for(unsigned int i=0; i<NumButtons; i++)
		if(ToggleControl * tgl=dynamic_cast<ToggleControl*>(buttonCtl->getSlots()[i]))
			if(tgl->getStatus())
				logdata << state->lastSensorUpdateTime << "\tBUTTON:\t" << i << '\t' << state->buttons[i] << '\n';
	for(unsigned int i=0; i<NumOutputs; i++)
		if(ToggleControl * tgl=dynamic_cast<ToggleControl*>(outputCtl->getSlots()[i]))
			if(tgl->getStatus())
				logdata << state->lastSensorUpdateTime << "\tOUTPUT:\t" << i << '\t' << state->outputs[i] << '\n';
	for(unsigned int i=0; i<NumPIDJoints; i++)
		if(ToggleControl * tgl=dynamic_cast<ToggleControl*>(dutyCtl->getSlots()[i]))
			if(tgl->getStatus())
				logdata << state->lastSensorUpdateTime << "\tDUTY:\t" << i << '\t' << state->pidduties[i] << '\n';
	if(consoleCtl->getStatus())
		sout->printf("%s",logdata.str().c_str());
	checkLogFile();
	if(logfile)
		logfile << logdata.str() << std::flush;
}

void SensorObserverControl::checkLogFile() {
	if(fileCtl->getLastInput()!=logfilePath) {
		logfile.close();
		logfilePath=fileCtl->getLastInput();
		logfile.clear();
		if(logfilePath.size()!=0) {
			sout->printf("Opening `/ms/%s'\n",logfilePath.c_str());
			logfile.open(("/ms/"+logfilePath).c_str());
			if(!logfile.fail()) {
				std::string tmp=fileCtl->getName();
				tmp[1]='X';
				fileCtl->setName(tmp+": "+logfilePath);
			} else {
				serr->printf("Opening `/ms/%s' failed\n",logfilePath.c_str());
			}
		}
	}
}

/*! @file
 * @brief Describes SensorObserverControl, which allows logging of sensor information to the console or file
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2003/12/23 06:33:41 $
 */
