//-*-c++-*-
#ifndef INCLUDED_PostureEditor_h_
#define INCLUDED_PostureEditor_h_

#include "ControlBase.h"
#include "Shared/SharedObject.h"
#include "Motion/PostureMC.h"
#include "Motion/MotionManager.h"
#include "StringInputControl.h"
#include "FileInputControl.h"

//! allows logging of events to the console or a file
class PostureEditor : public ControlBase {
public:
	//! constructor
	PostureEditor();

	//! adds #poseMC to MotionManager
	virtual ControlBase * activate(MotionManager::MC_ID disp_id, Socket * gui);

	//! if we're back from a child slot, it's either load or save, so we need to handle it
	virtual void refresh();

	//! removes #poseMC from MotionManager
	virtual void deactivate();

	//! opens a custom (embedded) menu edit outputs
	virtual ControlBase* doSelect();
	
protected:
	SharedObject<PostureMC> poseMC; //!< the actual memory space for the posture
	MotionManager::MC_ID poseID; //!< current id for the posture

	ControlBase* lastSlot; //!< the last accessed slot
	FileInputControl* loadPose; //!< the control for loading postures
	StringInputControl* savePose; //!< the control for saving postures

private:
	PostureEditor(const PostureEditor& ); //!< don't call
	PostureEditor& operator=(const PostureEditor& ); //!< don't call
};

/*! @file
 * @brief Describes PostureEditor, which allows numeric control of joints and LEDs
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:56 $
 */

#endif
