//-*-c++-*-
#ifndef INCLUDED_PlaySoundControl_h_
#define INCLUDED_PlaySoundControl_h_

#include "FileBrowserControl.h"
#include "SoundPlay/SoundManager.h"

//! Upon activation, loads a position from a file name read from cin (stored in ms/data/motion...)
class PlaySoundControl : public FileBrowserControl {
 public:
	//! Constructor
	PlaySoundControl(const std::string& n)
		: FileBrowserControl(n,"Plays a sound from a user specified sound file",config->sound.root)
	{
		setFilter("*.wav");
	}
	//! Destructor
	virtual ~PlaySoundControl() {}

protected:
	//!does the actual loading of the MotionSequence
	virtual ControlBase* selectedFile(const std::string& f) {
		sndman->StopPlay();
		if(sndman)
			sndman->PlayFile(f.c_str());
		return this;
	}
};

/*! @file
 * @brief Defines PlaySoundControl, which when activated, plays a sound selected from the memory stick
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0 $
 * $Revision: 1.6 $
 * $State: Rel $
 * $Date: 2003/09/25 15:26:11 $
 */

#endif
