function [Iwarp]=warpImage(Iin, H)
% Does problem 1.4
% Matrix H should have been computed such that pixels passed to computeH
% were scaled by 0.01 first.

%% 1. Handling Iwarp

% First find the image coordinates of the input image in the reference image
% coordinate system
indim = size(Iin);
corners = [ 1 1;			% top left
	    indim(2) 1;			% top right
	    1 indim(1); 		% bottom left
	    indim(2) indim(1) ]';	% bottom right
% Transform to math coordinates and back to indexed coordinates
corners = math2img( H*img2math(corners) );

% Find bounding box for transformed input image (Iwarp). This bounding box
% is in reference image coordinates.
minx = min(corners(1,:));
maxx = max(corners(1,:));
miny = min(corners(2,:));
maxy = max(corners(2,:));

% Find dimensions for Iwarp
dimx = maxx - minx + 1;
dimy = maxy - miny + 1;

if dimx > 400 | dimy > 400
  error(sprintf('Image dimensions too large: %dx%d',dimx,dimy));
end

% Find inverse of H (needed for what follows)
Hinv = inv(H);

% Create image coordinates of all the Iwarp pixels
[IwX,IwY] = meshgrid(minx:maxx,miny:maxy);
% Convert them to image coordinates of Iin
frompoints = math2img(Hinv*img2math([IwX(:) IwY(:)]'));

% Interpolate Iwarp values
Iwarp = interp2(Iin,frompoints(1,:),frompoints(2,:),'cubic');
% Zap NaN values from interpolator
Iwarp(find(isnan(Iwarp))) = 0;
% Reshape to proper size
Iwarp = reshape(Iwarp,dimy,dimx);


%% Helper functions
  
function mp=img2math(ip)
% Convert image coordinates to the homogeneous coordinates we use for math
mp = [ip*0.01; ones(1, size(ip,2))];
  
function ip=math2img(mp)
% Convert homogeneous coordinates used for math to image-size coordinates
ip = round( mp(1:2,:)*100 ./ [mp(3,:);mp(3,:)] );
 
function mps=math2math(mp)
% Scale homogeneous coordinates so that their scale factor is 1
mps = mp ./ [mp(3,:);mp(3,:);mp(3,:)];

