function H=computeH(pees, cues)
% Computes AFFINE transformation most likely to convert pees to cues.
% pees and cues are in pixel coordinates and share this form:
%  [ x x x x x x x ]
%  [ y y y y y y y ]

% Step 1: Convert pees and cues to homogeneous math coordinates, and
% transpose them
pees = img2math(pees)';
cues = img2math(cues)';

% Step 2: Construct enormous U matrix
% Technically, all third column entries should be multiplied by respective
% entries of pees(:,3). These values are all 1.0, however, since we just
% ran them through img2math.
U = [ -pees  zeros(size(pees))  cues(:,1) ; ... % For X coordinates
      zeros(size(pees))  -pees  cues(:,2) ];    % For Y coordinates

% Find the eigenvalues of U'*U, also known as W
[vects, vals] = eig(U'*U);
% Find the smallest eigenvalue from above
[tiny, index] = min(diag(vals));
% Exctract corresponding eigenvector
vect = vects(:,index)';

% Construct H matrix from eigenvector
H = [ vect(1:3); vect(4:6); 0 0 vect(7) ];



%% Helper functions
   
function mp=img2math(ip)
% Convert image coordinates to the homogeneous coordinates we use for math
mp = [ip*0.01; ones(1, size(ip,2))];
   
function ip=math2img(mp)
% Convert homogeneous coordinates used for math to image-size coordinates
ip = round( mp(1:2,:)*100 ./ [mp(3,:);mp(3,:)] );
  
function mps=math2math(mp)
% Scale homogeneous coordinates so that their scale factor is 1
mps = mp ./ [mp(3,:);mp(3,:);mp(3,:)];
