function stabilize5(path, outpath, motT, motC,start, burnin)
% Performs image stabilization on images in directory indicated by path.

% Configuration constants:
% Stabilized image size constants. Make sure they'll fit everything
S_cols = 450;
S_rows = 350;
% P factor (think PID controller) for enforcing zero rotation
R_Pfactor = 1/18;
% P factor for enforcing constant vertical image registration
V_Pfactor = 1/25;
% P factor for enforcing constant horizontal image registration
H_Pfactor = 1/25;

% Output image counter. Starts at 0
outcount = burnin-1;

% Get list of PNG files in path. The dir function will sort them by
% keyframe number.
Pngs = dir([path '/*.png']);

% Load the first image in the sequence
im1 = imread([path '/' Pngs(burnin).name]);
% Isolate a single channel and convert it to doubles
im1 = double(im1(:,:,1));
% Show image #1
S = register(zeros(S_rows,S_cols),im1,ones(size(im1)),S_cols,S_rows,0,0);
Sdisp = uint8(S(size(S,1)/2-size(im1,1)/2+(1:size(im1,1)),size(S,2)/2-size(im1,2)/2+(1:size(im1,2))));
figure; colormap gray; imagesc(Sdisp); axis equal; drawnow;
% Write this first image
imwrite(Sdisp,sprintf('%s/out%.5d.png',outpath,outcount)); outcount=outcount+1;
%subplot(1,2,1); colormap gray; imagesc(im1); axis equal;
%subplot(1,2,2); colormap gray; imagesc(im1); axis equal; drawnow;
%pause

% Initialize the homography we're computing throughout the sequence to I
H = eye(3);

H_err_log=[0];
curMT=1;
% lag time before actually starting to turn
lagT=500; %320; %550,400
% drift to the left (walk doesn't go straight when it's supposed to)
driftMod=.008; %.013; %.025,-.06
% speed calibration - doesn't quite go the speed it's supposed to)
speedMod=.59; %.58; %.61,1.03
motT=motT+lagT;
motC=(motC-driftMod)*176/57.6/25*speedMod;
off=motC(curMT);


% Loop through all the remaining images
for png = Pngs(burnin+1:length(Pngs))'
  % Load current image. Same procedure as before
  im2 = imread([path '/' png.name]); im2 = double(im2(:,:,1));
	curT = str2num(png.name(4:9))+start;
	if (curMT~=size(motT,2))
		while (motT(curMT+1)<curT)
			curMT=curMT+1;
			off=motC(curMT);
			if (curMT==size(motT,2))
				break;
			end
		end
	end
%	disp(sprintf('%d %d %d %g',curMT,curT-start,motT(curMT+1)-start,off));
	disp(sprintf('Image %s (%d): rotation: %g',png.name,outcount,off));
	
  % Compute H matrix between both images. Note that we don't carry over
  % the scaled image from before--we just multiply this H with the
  % H we're carrying through the whole sequence. By doing this, we
  % avoid image degradation problems that come from warping
  local_H = ransacH2(im2, im1);
  H = H*local_H;

  % Scale H to avoid numerical instability and facilitate calculations below.
  H = H / H(3,3);

  % LONG-TERM ERROR CORRECTION
  % 1. Rotation
  % Isolate rotation error from H matrix.
  R_err = -atan2(H(2,1),H(1,1));
  % Compute PID correction for error. Right now it's just P
  R_PID = R_err * R_Pfactor;
  % Correct with the PID correction
  R_correct = [ cos(R_PID) -sin(R_PID) 0; sin(R_PID) cos(R_PID) 0; 0 0 1 ];
  H = R_correct*H;

  % 2. Vertical displacement
  % Isolate vertical displacement from H matrix.
  V_err = -H(2,3);
  % Compute PID correction for error. Right now it's just P
  V_PID = V_err * V_Pfactor;
  % Correct with the PID correction
  H(2,3) = H(2,3) + V_PID;

  % 3. Horizontal displacement
  % Isolate horizontal displacement from H matrix.
	%disp(sprintf('%g %g %g',off,H(1,3),H(1,3)-off));
	H(1,3) = H(1,3) + off;
  H_err = -H(1,3);
	H_err_log(end+1)=H_err;
  % Compute PID correction for error. Right now it's just P
  H_PID = H_err * H_Pfactor;
  % Correct with the PID correction
  H(1,3) = H(1,3) + H_PID;

	% 4. Scaling
	sc_err = 1-sqrt(H(1,1)^2+H(1,2)^2);
	sc_PID = sc_err / 25;
	H(1:2,1:2) = H(1:2,1:2) * (1+sc_PID);
	
	% 5. Skew (?)
	sk_err = 1-(H(2,2)/H(1,1));
	sk_PID = sk_err / 40;
	H(2,1:2) = H(2,1:2) * (1+sk_PID);
	
	%pause;
  % Now show the warped image
  Iwarp = warpImage(im2,H);
  mask = warpImage(ones(size(im2)),H);
  %subplot(1,2,1); colormap gray; imagesc(im2); axis equal;
  %subplot(1,2,2); colormap gray; imagesc(Iwarp); axis equal;
  %drawnow;
  S = register(S,Iwarp,mask,S_cols,S_rows,H(1,3)*100,H(2,3)*100);
  Sdisp = uint8(S(size(S,1)/2-size(im2,1)/2+(1:size(im2,1)),size(S,2)/2-size(im2,2)/2+(1:size(im2,2))));
	if (off>0)
		Sdisp(end-1:end,(0:round(off*100))+88)=255;
	else
		Sdisp(end-1:end,(round(off*100):0)+88)=255;
	end
	disp(sprintf('skew: %g',sk_err));
	%Sdisp(end-10*round(1-sk_err*5):end,88)=255;
  colormap gray; imagesc(Sdisp); axis equal; drawnow;
  % Write this image
  imwrite(Sdisp,sprintf('%s/out%.5d.png',outpath,outcount)); outcount=outcount+1;

  % Stash im2 in im1 for the next iteration
  im1 = im2;
end

save H_err_log H_err_log;


% Helper functions

% Image registration
function Iout = register(Iout,Iin,mask,cols,rows,center_x,center_y)
% Save rows/2 and cols/2
r_half = round(rows/2);
c_half = round(cols/2);
% Save Iin dims and dims/2
[irows, icols] = size(Iin);
ir_half = round(irows/2);
ic_half = round(icols/2);
% Compute ranges for image transfer
crange = (1:icols) + c_half-ic_half + round(center_x);
rrange = (1:irows) + r_half-ir_half + round(center_y);
% Register
Iout(rrange,crange) = Iout(rrange,crange).*(1-mask);
%Iout = Iout*.75;
Iout(rrange,crange) = Iout(rrange,crange)+Iin;
