function D = makeD(X,Y)
% Makes the affine reconstruction data matrix from X and Y coordinates
% as described in the homework.

% First thing we do is find the centroid of all the frames
Xcentroids = sum(X,2) / size(X,2);
Ycentroids = sum(Y,2) / size(Y,2);

% Now we center all the feature coordinates
X = X - repmat(Xcentroids, 1, size(X,2));
Y = Y - repmat(Ycentroids, 1, size(Y,2));

% Construct D
D = [X; Y];
