function [X,Y] = getPtCorrs(im1,im2,numPoints)
%
%  [X,Y] = getPtCorrs(im1,im2,numPoints)
%
%  X and Y are [numPoints x 2] matrices such that the first column
%  contains coordinates from im1 and the second column contains im2.
%

[sy,sx] = size(im1);

if(~all(size(im1)==size(im2)))
    disp('Input images should be the same size!');
    return;
end

h=figure;
imshow([im1; im2]);
hold on

markers = '*+x';
colors = 'rgbmc';

for i=1:numPoints
    % get current indices for the color and marker to use for plotting this
    % pair of points
    m = mod(i-1,length(markers))+1;
    c = mod(i-1,length(colors))+1;
    
    figure(h)
    title(['Select a point in the top image (' num2str(i) ')'])
    [X(i,1),Y(i,1)] = ginput(1);
    plot(X(i,1),Y(i,1), [colors(c) markers(m)], 'LineWidth', 2, 'MarkerSize', 10);
    
    figure(h)
    title(['Select the corresponding point in the bottom image (' num2str(i) ')'])
    [X(i,2),Y(i,2)] = ginput(1);
    
    plot(X(i,2),Y(i,2), [colors(c) markers(m)], 'LineWidth', 2, 'MarkerSize', 10);
    
    Y(i,2) = Y(i,2)-sy;
end
title('Done.')

hold off