function [Iwarp,Imerge]=warpImage(Iin, Iref, H)
% Does problem 1.4
% Matrix H should have been computed such that pixels passed to computeH
% were scaled by 0.01 first.

%% 1. Handling Iwarp

% First find the image coordinates of the input image in the reference image
% coordinate system
indim = size(Iin(:,:,1));
corners = [math2img(H*img2math([0;0])) ...		% top left
	   math2img(H*img2math([indim(2);0])) ...	% top right
	   math2img(H*img2math([0;indim(1)])) ...	% bottom left
	   math2img(H*img2math([indim(2);indim(1)]))];	% bottom right

% Find bounding box for transformed input image (Iwarp). This bounding box
% is in reference image coordinates.
minx = min(corners(1,:));
maxx = max(corners(1,:));
miny = min(corners(2,:));
maxy = max(corners(2,:));

% Find dimensions for Iwarp
dimx = maxx - minx
dimy = maxy - miny

% Init Iwarp with black
Iwarp = uint8(zeros(dimy,dimx,3));

% Find inverse of H (needed for what follows)
Hinv = inv(H);

% Fill in points in Iwarp. My Matlab skillz are not cool.
for y = 1:dimy
  for x = 1:dimx
    % Compute source for current pixel (frompoint)
    topoint = [minx + x ; miny + y];
    frompoint = math2img(Hinv*img2math(topoint));

    % Make sure frompoint is in bounds
    if frompoint(1) < 1; continue; end;
    if frompoint(2) < 1; continue; end;
    if frompoint(1) > indim(2); continue; end;
    if frompoint(2) > indim(1); continue; end;

    % Copy data at frompoint
    Iwarp(y,x,:) = Iin(frompoint(2),frompoint(1),:);
  end
end


%% 2. Handling Imerge

% Save x and y offset of warped image
warpoff = [minx; miny];

% Find bounding box for the merged image
refdim = size(Iref(:,:,1));
corners = [ [minx;miny] [maxx;maxy] ...
	    [0;0] [refdim(2);0] [0;refdim(1)] [refdim(2);refdim(1)] ];
minx = min(corners(1,:));
maxx = max(corners(1,:));
miny = min(corners(2,:));
maxy = max(corners(2,:));

% Find dimensions for Imerge
mdimx = maxx - minx;
mdimy = maxy - miny;

% Init Imerge with black
Imerge = uint8(zeros(mdimy,mdimx,3));

% Fill in points in Imerge. My Matlab skillz are still not cool.
for y = 1:mdimy
  for x = 1:mdimx
    % Compute source for current pixel in reference coordinates
    fromrefpoint = [minx + x; miny + y];
    % Compute source for current pixel in indices into the warped image
    fromwarppoint = fromrefpoint - warpoff;

    % If we're in bounds for the warp image, copy that pixel over
    if (fromwarppoint(1) >= 1) && (fromwarppoint(2) >= 1) && ...
       (fromwarppoint(1) <= dimx) && (fromwarppoint(2) <= dimy)
      Imerge(y,x,:) = Iwarp(fromwarppoint(2),fromwarppoint(1),:);
    end

    % If we're in bounds for the reference image, copy that pixel over
    if (fromrefpoint(1) >= 1) && (fromrefpoint(2) >= 1) && ...
       (fromrefpoint(1) <= refdim(2)) && (fromrefpoint(2) <= refdim(1))
      Imerge(y,x,:) = Iref(fromrefpoint(2),fromrefpoint(1),:);
    end
  end
end


%% Helper functions

function mp=img2math(ip)
% Convert image coordinates to the homogeneous coordinates we use for math
mp = [ip*0.01; 1];

function ip=math2img(mp)
% Convert homogeneous coordinates used for math to image-size coordinates
ip = round(mp(1:2) * 100 / mp(3));
