#include "StartupBehavior.h"

#include "Behaviors/Controls/ControlBase.h"

#include "Behaviors/Controls/LoadPostureControl.h"
#include "Behaviors/Controls/SavePostureControl.h"
#include "Behaviors/Controls/RunSequenceControl.h"
#include "Behaviors/Controls/PlaySoundControl.h"
#include "Behaviors/Controls/DumpFileControl.h"

ControlBase*
StartupBehavior::SetupFileAccess() {
	addItem(new ControlBase("File Access","Access/load files on the memory stick"));
	startSubMenu();
	{ 
		addItem(new LoadPostureControl("Load Posture",stop_id));
		addItem(new SavePostureControl("Save Posture"));
		addItem(new RunSequenceControl<MotionSequence::SizeXLarge>("Run Motion Sequence",stop_id));
		addItem(new PlaySoundControl("Play Sound"));
		addItem(new DumpFileControl("Files","/ms"));
	}
	return endSubMenu();
}
