/*
 * agmMain.h -- defines the main class for interfacing with the AIBO
 *   Global (height) Map.
 *
 * Started 1-21-2002, tss
 */

#ifndef _AGM_MAIN_H_
#define _AGM_MAIN_H_

#include "almStructures.h"
#include "../WorldModel2.h"
#include <iostream>

// This class contains method declarations for interfacint with the AIBO
// Global Map. Same C in disguise as C++ deal as the Local Map. It's not
// my fault--if we had a working malloc, things would be different!
class AGM
{
// WorldModel2 has access to us to gather motion requests
friend class WorldModel2;

public:
  // This method initializes the static table used to hold the map data.
  // Yes, you have to manually run an initializer. I apologize!
  static void init(void);

  // Carry over information from the local height map. More literally,
  // see about placing height map cell at x,y. We may not do it if data
  // there are from a measurement we're more confident about.
  static void carryOver(double x, double y, hm_cell &cell);

  // Tax the certainty of the global map after a move
  static void decay();

  // Dump map data selected by a hmPicker you implement (or just
  // instantiate) into the supplied iostream. Uses ASCII .mat file
  // "format", seperating row elements with tabs and rows with newlines.
  static void dump(hmPicker &p, std::ostream &out);

  // What this thing does with all this information remains to be seen...

#ifndef UNIT_TEST_AGM_MA
private:
#endif

  // This method generates motion requests for WorldModel2. It's the reason
  // WorldModel2 is our friend.
  static void genRequests(MRvector &requests);

  // This method provides direct access to the global map data array. You
  // should use GM_CELL_COUNT to index the array. This method is PRIVATE
  // and is intended only for use by WorldModel2 objects.
  // Whenever you want to access the GM array, you should always call
  // this routine before doing your manipulation. This is because 
  // double buffering may be used here, and you may find yourself pointing at
  // an old buffer if you don't update your pointers.
  static hm_cell *getGM();
};

#endif
