/* Utility routines for handling afsParticle structures in AIBO FastSLAM */

#ifdef __cplusplus
extern "C" {
#endif

#include "afsParticle.h"
#include <string.h>

void afsParticleInit(afsParticle *p)
{
  int i;

  p->pose.x = p->pose.y = p->pose.theta = 0;
  p->gotweight = 0;
  p->weight = 1.0; /* Why 1.0? See afsMeasurementUpdate */

  for(i=0; i<AFS_NUM_LANDMARKS; ++i) {
    p->landmarks[i].mean.x = 1980;	/* warning value */
    p->landmarks[i].mean.y = 1980;
    p->landmarks[i].variance.x = 1980;
    p->landmarks[i].variance.y = 1980;
    p->landmarks[i].variance.xy = 1980;

    p->landmarks[i].state = PRIMING;
    p->landmarks[i].priming.empty = 1;
  }
}

void afsParticleCopy(afsParticle *old, afsParticle *neu)
{
  memcpy(neu, old, sizeof(afsParticle));
}

#ifdef __cplusplus
}
#endif
