#ifndef _AFS_MOTION_RESAMPLE_H_
#define _AFS_MOTION_RESAMPLE_H_

/*
 * Motion resampling code for AIBO FastSLAM
 */

#include "afsParticle.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Probabilistically updates the location of afsParticle p based on an
 * ad-hoc motion model for the Aibo. dx, dy, and da are the velocities
 * sent to the WalkMC object and time is the duration of time
 * (in milliseconds) that they were executed. */
void afsMotionResample(afsParticle *p,
			double dx, double dy, double da, unsigned int time);

#ifdef __cplusplus
}
#endif
#endif
