/*
 * Measurement update code for the AIBO FastSLAM.
 *
 * The routines here are used to update the particles' ideas of where
 * landmarks are after new sensor information is collected. One of two
 * things can occur here:
 *
 * 1. The particle already has an estimate of where the landmark is
 *    located. New measurement information is integrated with the
 *    existing estimate using standard extended Kalman filter techniques
 *    (thanks, Mike!).
 *
 * 2. There is no estimate yet. To create an estimate, good old fashioned
 *    triangulation is used to create a Gaussian that roughly matches the
 *    location of the landmark. This requires multiple sightings, though,
 *    and in some cases the routine will just cache information about the
 *    particle location without doing anything, waiting until the next
 *    measurement to create the estimate.
 *
 * The measurement update routines will also compute a weight for the
 * subsequent particle resampling step IF this is possible. It may not be
 * possible if this particle has not been able to triangulate a landmark's
 * location yet, or if it has just completed a triangulation. If a weight
 * is computed, the particle's gotweight member will be set to true and
 * its weight member will be filled with the weight. If not, gotweight will
 * be false.
 */

#include "afsParticle.h"

#ifndef _AFS_MEASUREMENT_UPDATE_H_
#define _AFS_MEASUREMENT_UPDATE_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Perform the measurement update detailed above. */
void afsMeasurementUpdate(afsParticle *p, int landmark, double theta);

#ifdef __cplusplus
}
#endif

#endif
