import java.io.InputStream;
import java.net.Socket;
import java.awt.Image;
import java.awt.image.IndexColorModel;
import java.awt.image.BufferedImage;
import java.util.Date;

public class VisionPGSSListener extends VisionListener {
    static int width=176;
    static int height=144;
    byte[] _data=new byte[22*height*3*2];
    byte[] _outd=new byte[width*height];
    static int defPort=10012;
    static final boolean _debug=false;
    
    //
    // BEGINNING OF PGSS FIELDS
    //
    
    int[][] regionMap = new int[width][height];
    int[] regionSizes = new int[width*height/2];
    int targetX = width/2, targetY = height/2;
    int lastTargetsSize = 25;
    int lastTargetsCount = 0;
    int[] lastTargets = new int[lastTargetsSize];
    boolean scaleVelocity = true;
    double scaledVelocity = 0;
    int userPreferredVelocity = 0;
    int regionOfInterest = -2;
    int scalingFactor = 75;
    PGSSWalkGUI walkGUI = null;
    
    //
    // END OF PGSS FIELDS
    //
    
    //todo: read this from the same file the dog is using
    static final byte cmap[]={ (byte)  0, (byte)  0, (byte)  0,
			       (byte)  0, (byte)  0, (byte)  0,
			       (byte)  0, (byte)128, (byte)255,
			       (byte)  0, (byte)128, (byte)  0,
			       (byte)255, (byte)128, (byte)  0,
			       (byte)  0, (byte)255, (byte)  0,
			       (byte)128, (byte)  0, (byte)255,
			       (byte)255, (byte)  0, (byte)  0,
			       (byte)255, (byte)128, (byte)228,
			       (byte)255, (byte)255, (byte)  0,
			       (byte)200, (byte)200, (byte)228,
			       (byte)200, (byte)100, (byte)  0  };
    IndexColorModel _cmodel=new IndexColorModel(7, 12, cmap, 0, false);
    BufferedImage img=new BufferedImage(width,height,BufferedImage.TYPE_BYTE_INDEXED,_cmodel);
    
    void connected(Socket socket) {
	_isConnected=true;
	fireVisionUpdate();
	try {
	    InputStream in=socket.getInputStream();
	    while (true) {
		int size=readInt(in);
		if(!_isConnected) break;
		size=size*3;
		readBytes(_data, in, size);
		if(!_isConnected) break;
		timestamp=new Date();
		decodeRLE(size);
		processFrame();
		setRotation();
		fireVisionUpdate();
	    }
	} catch (Exception ex) { }
	
	try { socket.close(); } catch (Exception ex) { }
	_isConnected=false;
	fireVisionUpdate();
    }
    
    void decodeRLE(int pktSize) {
	int curx=0, cury=0;
	int dlength=pktSize;
	int dpos=0;
	
	synchronized (_outd) {
	    for (; dlength>=3 && cury<height;) {
		byte color;
		color=_data[dpos++];
		color++;
		int x=b2i(_data[dpos++]);
		int len=b2i(_data[dpos++]);
		dlength-=3;
		if (x < curx) {
		    if (_debug) System.out.println("backwards x movement");
		    break;
		}
		
		for (; curx < x; curx++)
		    _outd[cury*width+curx]=1;
		
		if (curx+len>width) {
		    if (_debug) System.out.println("run past end");
		    break;
		}
		
		for (; len>0; len--, curx++)
		    _outd [cury*width+curx]=color;
		if (curx==width) {
		    cury++;
		    curx=0;
		}
	    }
	}
	if (cury!=height) {
	    if (_debug) System.out.println("early end of data\n");
	}
    }
    
    public byte[] getData() {
	//		frameTimer();
	synchronized (_outd) {
	    updatedFlag=false;
	    return _outd;
	}
    }
    
    public BufferedImage getImage() {
	synchronized (_outd) {
	    byte[] data=getData();
	    img.getRaster().setDataElements(0,0,width,height,data);
	}
	return img;
    }
    
    //
    // BEGINNING OF PGSS METHODS
    //
    
    public void processFrame() {
	for(int y=0; y<height; y++) {
	    for(int x=0; x<width; x++) {
		if((int) _outd[x+y*width] == 8) {
		    regionMap[x][y] = 0;
		}
		else {
		    regionMap[x][y] = -1;
		}
	    }
	}
	
	for(int i=0; i<width*height/2; i++) {
	    regionSizes[i] = 0;
	}
	
	int currentRegion = 1;
	
	for(int y=0; y<height; y++) {
	    for(int x=0; x<width; x++) {
		if(regionMap[x][y]==0) {
		    fillRegion(x, y, currentRegion++);
		}
	    }
	}
	
	setTargetByLargestRegionOnCenter(currentRegion);
	// setTargetByConsideringSlope(currentRegion);
    }
    
    private void setTargetByLargestRegionOnCenter(int onePastLastRegion) {
	boolean pixelInCenterRow = false;
	int previousRegionSize = width*height;
	int largestRegionLabel = 1;
	int regionsChecked = 0;
	
	while(!pixelInCenterRow && regionsChecked < onePastLastRegion) {
	    int largestRegionSize  = regionSizes[1];
	    int i;

	    largestRegionLabel = 1;
	    
	    for(i=2; i<onePastLastRegion; i++) {
		if((regionSizes[i] > largestRegionSize) &&
		   (regionSizes[i] < previousRegionSize)) {
		    largestRegionSize  = regionSizes[i];
		    largestRegionLabel = i;
		}
	    }
	    
      	    int sumX = 0, numX = 0;
	    targetX = 0;
	    targetY = height/2;
	    
	    for(int x=0; x<width; x++) {
		if(regionMap[x][targetY] == largestRegionLabel) {
		    sumX += x;
		    numX += 1;
		}
	    }
	    
	    if(numX>0) {
		targetX = sumX / numX;
		pixelInCenterRow = true;
		regionOfInterest = largestRegionLabel;
		
		lastTargets[lastTargetsCount] = (targetX>width/2)?1:-1;
		
		if(lastTargetsCount==lastTargetsSize-1) {
		    lastTargetsCount = 0;
		}
		else {
		    lastTargetsCount++;
		}	
	    }
	    else {
		previousRegionSize = regionSizes[largestRegionLabel];
	    }
	    
	    regionsChecked++;
	} // end find-largest-region-on-center-line loop
	
	if(regionsChecked==onePastLastRegion) { // dog is lost
	    int sum = 0;
	    
	    for (int i=0; i<lastTargetsSize; i++) {
		sum += lastTargets[i];
	    }
	    
	    targetX = (sum<0)?0:width;
	    
	    if(walkGUI!=null) {
		walkGUI.setXValue(0);
		scalingFactor=50;
	    }
	}
	else { // dog isn't lost
	    int highestX = -1;
	    for(int x=0; x<width; x++) {
		for(int y=0; y<height; y++) {
		    if(highestX==-1 && regionMap[x][y]==largestRegionLabel) {
			highestX = x;
			// System.out.println("highestX = " + highestX);
		    }
		}
	    }
	    
	    int deflectionDistance = Math.abs(highestX - targetX);
	    // System.out.println("highestX = " + highestX);
	    // System.out.println("targetX = " + targetX);
	    // System.out.println("deflectionDistance = " + deflectionDistance);
	    double scaleFactor = 1 - ((double) deflectionDistance)/((double)width);
	    double userPreferredVelocityScaled =
		userPreferredVelocity * Math.pow(scaleFactor, 3/2);
	    
	    if(walkGUI!=null) {
		if(scaleVelocity) {
		    // System.out.println("userPreferredVelocity = " +
		    // userPreferredVelocity);
		    // System.out.println("userPreferredVelocityScaled = " +
		    // userPreferredVelocityScaled);
		    walkGUI.setXValue((int) userPreferredVelocityScaled);
		}
		else {
		    walkGUI.setXValue(userPreferredVelocity);
		}
		scalingFactor=75;
	    }
	}
	
	paintRow(height/2);
	paintTargetBox();
    }
    
    public void setTargetByConsideringSlope(int onePastLastRegion) {
	int centerTargetX = targetX;
	int centerTargetY = targetY;
	
	setTargetByLargestRegionOnCenter(onePastLastRegion);
	paintRow(height/2);
	paintTargetBox();
	if(targetX<(width/4) || targetX>(width*3/4)) {
	    paintColumn(width/4);
	    paintColumn(width*3/4);
	    if(isRegionOfInterestOnRow(height/4)) {
		paintRow(height/4);
		paintTargetBox();
		int topTargetX = targetX;
		int topTargetY = targetY;
		if(isRegionOfInterestOnRow(height*3/4)) {
		    paintRow(height*3/4);
		    paintTargetBox();
		    int bottomTargetX = targetX;
		    int bottomTargetY = targetY;
		    if(centerTargetX<(width/2)) {
			if((centerTargetX>bottomTargetX) && (centerTargetX<topTargetX)) {
			    centerTargetX = width/2;
			    paintColumn(width/4, 4);
			    paintColumn(width*3/4, 4);
			}
		    }
		    else if(centerTargetX>(width/2)) {
			if((centerTargetX<bottomTargetX) && (centerTargetX>topTargetX)) {
			    centerTargetX = width/2;
			    paintColumn(width/4, 4);
			    paintColumn(width*3/4, 4);
			}
		    }
		}
	    }
	    
	    targetX = centerTargetX;
	    targetY = centerTargetY;
	}
    }
    
    private boolean isRegionOfInterestOnRow(int row) {
	boolean regionFound = false;
	
	for(int x=0; x<width; x++) {
	    if(regionMap[x][row] == regionOfInterest) {
		return true;
	    }
	}
	
	return false;
    }
    
    private void setRotation() {
	if(walkGUI!=null) {
	    walkGUI.setAValue((width/2-targetX)*-scalingFactor);
	}
    }
    
    public void setUserPreferredVelocity(int userPreferredVelocity) {
	this.userPreferredVelocity = userPreferredVelocity;
    }
    
    private void fillRegion(int x, int y, int regionColor) {
	if(x>=0 && x<width && y>=0 && y<height && regionMap[x][y]==0) {
	    regionMap[x][y] = regionColor;
	    regionSizes[regionColor]++;
	    
	    fillRegion(x+1, y,   regionColor);
	    fillRegion(x+1, y+1, regionColor);
	    fillRegion(x,   y+1, regionColor);
	    fillRegion(x-1, y+1, regionColor);
	    fillRegion(x-1, y,   regionColor);
	    fillRegion(x-1, y-1, regionColor);
	    fillRegion(x,   y-1, regionColor);
	    fillRegion(x+1, y-1, regionColor);
	}
    }
    
    private void paintTargetBox() {
	for(int y=(targetY-1); y<(targetY+2); y++) {
	    for(int x=(targetX-1); x<(targetX+2); x++) {
		if(x>=0 && x<width && y>=0 && y<height ) {
		    _outd[x+y*width] = (byte) 2;
		}
	    }
	}
    }
    
    private void paintTargetBox(int color) {
	for(int y=(targetY-1); y<(targetY+2); y++) {
	    for(int x=(targetX-1); x<(targetX+2); x++) {
		if(x>=0 && x<width && y>=0 && y<height ) {
		    _outd[x+y*width] = (byte) color;
		}
	    }
	}
    }
    
    private void paintRow(int row) {
	for(int x=0; x<width; x+=3) {
	    _outd[x+row*width] = (byte) 6;
	}
    }

    private void paintRow(int row, int color) {
	for(int x=0; x<width; x+=3) {
	    _outd[x+row*width] = (byte) color;
	}
    }

    private void paintColumn(int col) {
	for(int y=0; y<height; y+=3) {
	    _outd[col+y*width] = (byte) 6;
	}
    }

    private void paintColumn(int col, int color) {
	for(int y=0; y<height; y+=3) {
	    _outd[col+y*width] = (byte) color;
	}
    }

    public void printRegionMap() {
	/*******DEBUG*******
		System.out.println("=========== REGION MAP ===========");
		System.out.println();
		for(int y=0; y<height; y++) {
		for(int x=0; x<width; x++) {
		System.out.print(regionMap[x][y]);
		}
		System.out.println();
		}
		
		System.out.println("========== REGION SIZES ==========");
		System.out.println();
		for(int i=0; i<width*height/2; i++) {
		System.out.println("regionSizes[" + i + "] = " + regionSizes[i]);
		}
	*******************/
    }
    
    //
    // END OF PGSS METHODS
    //
    
    public VisionPGSSListener() {
	super();
    }
    public VisionPGSSListener(int port) { 
	super(port);
    }
    public VisionPGSSListener(String host, int port) {
	super(host,port);
    }

    public VisionPGSSListener(String host, int port, PGSSWalkGUI walkGUI) {
	super(host,port);
	this.walkGUI=walkGUI;
    }
}
