#include "FilterBankGenerator.h"
#include "Events/EventRouter.h"

unsigned char *
FilterBankGenerator::getImage(unsigned int layer, unsigned int channel) const {
	//for(int i=0;i<1000;i++)
	//std::cout << i << " FBG::getImage(" << layer<<'/'<<numLayers  << ',' << channel<<'/'<<numChannels << ");" << std::endl;
	if(!imageValids[layer][channel]) {
		if(images[layer][channel]==NULL)
			images[layer][channel]=createImageCache(layer,channel);
		calcImage(layer,channel);
	}
	return images[layer][channel];
}

void 
FilterBankGenerator::freeCaches() {
	invalidateCaches();
	for(unsigned int i=0; i<numLayers; i++)
		for(unsigned int j=0; j<numChannels; j++) {
			delete [] images[i][j];
			images[i][j]=NULL;
		}
}

void
FilterBankGenerator::invalidateCaches() {
	for(unsigned int i=0; i<numLayers; i++)
	  for(unsigned int j=0; j<numChannels; j++)
	    imageValids[i][j]=false;
}


unsigned int FilterBankGenerator::getBinSize() const {
	unsigned int used=0;
	used+=creatorSize("FbkImage");
	used+=sizeof(widths[selectedSaveLayer]);
	used+=sizeof(heights[selectedSaveLayer]);
	used+=sizeof(selectedSaveLayer);
	used+=sizeof(selectedSaveChannel);
	return used;
}

/*! The LoadBuffer() functions of the included subclasses aren't tested, so don't assume they'll work without a little debugging... */
unsigned int FilterBankGenerator::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=checkCreator("FbkImage",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(widths[selectedSaveLayer],buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(heights[selectedSaveLayer],buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(selectedSaveLayer,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(selectedSaveChannel,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;	
}

unsigned int FilterBankGenerator::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=saveCreator("FbkImage",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(widths[selectedSaveLayer],buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(heights[selectedSaveLayer],buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(selectedSaveLayer,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(selectedSaveChannel,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;
}

void
FilterBankGenerator::setNumImages(unsigned int nLayers, unsigned int nChannels) {
	freeCaches();
	destruct();
	numLayers=nLayers;
	numChannels=nChannels;
	widths=new unsigned int[numLayers];
	heights=new unsigned int[numLayers];
	skips=new unsigned int[numLayers];
	strides=new unsigned int[numLayers];
	increments=new unsigned int[numLayers];
	for(unsigned int res=0; res<numLayers; res++) {
		widths[res]=heights[res]=skips[res]=strides[res]=0;
		increments[res]=1;
	}
	images=new unsigned char**[numLayers];
	imageValids=new bool*[numLayers];
	for(unsigned int i=0; i<numLayers; i++) {
		widths[i]=heights[i]=0;
		images[i]=new unsigned char*[numChannels];
		imageValids[i]=new bool[numChannels];
		for(unsigned int j=0; j<numChannels; j++) {
			images[i][j]=NULL;
			imageValids[i][j]=false;
		}
	}
}

void
FilterBankGenerator::destruct() {
	delete [] widths;
	widths=NULL;
	delete [] heights;
	heights=NULL;
	delete [] skips;
	skips=NULL;
	delete [] strides;
	strides=NULL;
	delete [] increments;
	increments=NULL;
	for(unsigned int i=0; i<numLayers; i++) {
		delete [] images[i];
		delete [] imageValids[i];
	}
	delete [] images;
	images=NULL;
	delete [] imageValids;
	imageValids=NULL;
	numLayers=numChannels=0;
}



/*! @file
 * @brief Implements abstract base class for generators of FilterBankEvent's
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.5 $
 * $State: Exp $
 * $Date: 2004/02/05 19:11:41 $
 */

