//-*-c++-*-
#ifndef INCLUDED_ProjectInterface_h_
#define INCLUDED_ProjectInterface_h_

//! A collection of the global variables which should be set by a project to use the Tekkotsu framework
/*! You don't necessarily need to define all of these, but if you want
 *  to use the built in demo behaviors, you may need to set some
 *  values in here appropriately so that the demos can adapt to your
 *  project's configuration.
 *  
 *  Any references should be instantiated in your own project files
 *  (since you can't reassign a reference)
 *
 *  Any pointers are instantiated in ProjectInterface.cc and
 *  initialized to NULL. You can reassign them as you see fit.
 *
 *  Currently, all required members are references (so they can't be
 *  set to NULL and you'll get errors if you leave them out) and all
 *  optional settings are pointers so you can ignore them if you want.
 */

class BehaviorBase;
class FilterBankGenerator;

namespace ProjectInterface {
	
	//! REQUIRED: you must define a behavior which will be started when the boot is complete
	/*! This is similar in idea to the Linux init process - it should do
	 *  some basic initialization and then launch any other behavior you
	 *  would like to run at boot. */
	extern BehaviorBase& startupBehavior;

	//! A collection of the various stages of vision processing.  None of these are absolutely required, but are needed to run included demo behaviors and TekkotsuMon modules
	/*! @name Vision Setup */
	//! pointer to generator
	extern FilterBankGenerator * defRawCameraGenerator;
	extern FilterBankGenerator * defInterleavedYUVGenerator;
	extern FilterBankGenerator * defColorJPEGGenerator;
	extern FilterBankGenerator * defGrayscaleJPEGGenerator;
	extern FilterBankGenerator * defSegmentedColorGenerator;
	extern FilterBankGenerator * defRLEGenerator;
	extern FilterBankGenerator * defRegionGenerator;
	//@}

	//! Default source IDs for the various generators; These are given default values, but you can reassign them if you like.
	/*! @name Vision SIDs */
	//! source id for event
	extern unsigned int visRawCameraSID;
	extern unsigned int visInterleaveSID;
	extern unsigned int visColorJPEGSID;
	extern unsigned int visGrayscaleJPEGSID;
	extern unsigned int visSegmentSID;
	extern unsigned int visRLESID;
	extern unsigned int visRegionSID;
	extern unsigned int visPinkBallSID;
	extern unsigned int visBlueBallSID;
	extern unsigned int visHandSID;
	//@}

	//! Allows you to request a particular layer abstractly - this isn't used by the framework, just a suggestion for clarity
	/*! @name Layer Resolutions */
	extern unsigned int doubleLayer;   //!< ERS-2xx: 352*288; ERS-7 416*320 (requires non-trivial computation)
	extern unsigned int fullLayer;     //!< ERS-2xx: 176*144; ERS-7 208*160
	extern unsigned int halfLayer;     //!< ERS-2xx: 88*72; ERS-7 104*80
	extern unsigned int quarterLayer;  //!< ERS-2xx: 44*36; ERS-7 52*40
	extern unsigned int eighthLayer;   //!< ERS-2xx: 22*18; ERS-7 26*20 (simply a bigger interleave referencing quarterLayer)
	extern unsigned int sixteenthLayer;//!< ERS-2xx: 11*9; ERS-7 13*10 (simply a bigger interleave referencing quarterLayer)
	//@}
}

/*! @file
 * @brief Defines ProjectInterface namespace - a collection of the global variables which should be set by a project to use the Tekkotsu framework
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.4 $
 * $State: Exp $
 * $Date: 2003/12/11 05:49:30 $
 */

#endif
