#include "VisionObjectEvent.h"

unsigned int
VisionObjectEvent::getBinSize() const {
	unsigned int used=EventBase::getBinSize();
	used+=creatorSize("EventBase::VisionObjectEvent");
	used+=sizeof(_cenX);
	used+=sizeof(_cenY);
	used+=sizeof(_distance);
	//used+=sizeof(_property);
	return used;
}

unsigned int
VisionObjectEvent::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=checkCreator("EventBase::VisionObjectEvent",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(_cenX,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(_cenY,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(_distance,buf,len))) return 0;
	len-=used; buf+=used;
	//if(0==(used=decode(_property,buf,len))) return 0;
	//len-=used; buf+=used;
	return origlen-len;	
}

unsigned int
VisionObjectEvent::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used;
	if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=saveCreator("EventBase::VisionObjectEvent",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(_cenX,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(_cenY,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(_distance,buf,len))) return 0;
	len-=used; buf+=used;
	//if(0==(used=encode(_property,buf,len))) return 0;
	//len-=used; buf+=used;
	return origlen-len;
}

