#ifndef INCLUDED_LocomotionEvent_h_
#define INCLUDED_LocomotionEvent_h_

#include "EventBase.h"

//! Gives updates regarding the current movement of the robot through the world
/*! An activate event will be sent when a potential source of motion is created,
 *  and a deactivate when it is destroyed.  Status events will be sent at any
 *  change of direction/speed.
 *
 *  The source ID field will hold the MotionManager::MC_ID of the sending MotionCommand
 */
class LocomotionEvent : public EventBase {
 public:

	//! @name Constructors

	//! constructor
	LocomotionEvent() : EventBase(),x(0),y(0),a(0) {}
	LocomotionEvent(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur=0) : EventBase(gid,sid,tid,dur),x(0),y(0),a(0) {}
	LocomotionEvent(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur, const std::string& n, float mag) : EventBase(gid,sid,tid,dur,n,mag),x(0),y(0),a(0) {}
	//@}

	//! Allows you to set the new X, Y, and A components
	LocomotionEvent& setXYA(float X, float Y, float A) {
		x=X;
		y=Y;
		a=A;
		return *this;
	}
	
	virtual unsigned int getBinSize() const {
		unsigned int used=EventBase::getBinSize();
		used+=creatorSize("EventBase::LocomotionEvent");
		used+=sizeof(x);
		used+=sizeof(y);
		used+=sizeof(a);
		return used;
	}

	virtual unsigned int LoadBuffer(const char buf[], unsigned int len) {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::LoadBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=checkCreator("EventBase::LocomotionEvent",buf,len,true))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(x,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(y,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=decode(a,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;	
	}

	virtual unsigned int SaveBuffer(char buf[], unsigned int len) const {
		unsigned int origlen=len;
		unsigned int used;
		if(0==(used=EventBase::SaveBuffer(buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=saveCreator("EventBase::LocomotionEvent",buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(x,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(y,buf,len))) return 0;
		len-=used; buf+=used;
		if(0==(used=encode(a,buf,len))) return 0;
		len-=used; buf+=used;
		return origlen-len;
	}

	float x; //!< the new x component (body relative)
	float y; //!< the new y component (body relative)
	float a; //!< the new angular component (body relative)
};

/*! @file
 * @brief Defines LocomotionEvent, which gives updates regarding the current movement of the robot through the world
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.5 $
 * $State: Rel $
 * $Date: 2003/09/25 15:27:10 $
 */

#endif
