#include "EventBase.h"
#include <stdio.h>

const char* const EventBase::EventGeneratorNames[numEGIDs] = {
	"UnknownGen",
	"AI",
	"Audio",
	"Button",
	"EventRouter",
	"EStop",
	"Locomotion",
	"MotionManager",
	"Power",
	"Sensor",
	"StateMachine",
	"TextMsg",
	"Timer",
	"VisionOFbkVector",
	"VisionRawCamera",
	"VisionInterleaver",
	"VisionJPEGCompressor",
	"VisionSegmenter",
	"VisionRLEEncoder",
	"VisionRegionConnector",
	"VisionObjectDetector",
	"WMVariable",
	"WorldModel",
};


EventBase::EventBase()
	: LoadSave(), stim_id(), magnitude(0), timestamp(get_time()), nameisgen(true), genID(unknownEGID), typeID(statusETID), sourceID((unsigned int)-1), duration(0)
{
	genName();
}

EventBase::EventBase(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur)
	: LoadSave(), stim_id(), magnitude(0), timestamp(get_time()), nameisgen(true), genID(gid), typeID(tid), sourceID(sid), duration(dur)
{
	genName();
	if(tid==deactivateETID)
		setMagnitude(0.0);
	else
		setMagnitude(1.0);
}

EventBase::EventBase(EventGeneratorID_t gid, unsigned int sid, EventTypeID_t tid, unsigned int dur, const std::string& n, float mag)
	: LoadSave(), stim_id(n), magnitude(mag), timestamp(get_time()), nameisgen(false), genID(gid), typeID(tid), sourceID(sid), duration(dur)
{
	
}


unsigned int
EventBase::getBinSize() const {
	unsigned int used=0;
	used+=creatorSize("EventBase");
	used+=stim_id.size()+stringpad;
	used+=sizeof(magnitude);
	used+=sizeof(timestamp);
	used+=sizeof(nameisgen);
	used+=sizeof(char);
	used+=sizeof(char);
	used+=sizeof(sourceID);
	used+=sizeof(duration);
	return used;
}

unsigned int
EventBase::LoadBuffer(const char buf[], unsigned int len) {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=checkCreator("EventBase",buf,len,true))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(stim_id,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(magnitude,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(timestamp,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(nameisgen,buf,len))) return 0;
	len-=used; buf+=used;
	char tmp;
	if(0==(used=decode(tmp,buf,len))) return 0;
	genID=(EventGeneratorID_t)tmp;
	len-=used; buf+=used;
	if(0==(used=decode(tmp,buf,len))) return 0;
	typeID=(EventTypeID_t)tmp;
	len-=used; buf+=used;
	if(0==(used=decode(sourceID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=decode(duration,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;	
}

unsigned int
EventBase::SaveBuffer(char buf[], unsigned int len) const {
	unsigned int origlen=len;
	unsigned int used=0;
	if(0==(used=saveCreator("EventBase",buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(stim_id,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(magnitude,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(timestamp,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(nameisgen,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode((char)genID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode((char)typeID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(sourceID,buf,len))) return 0;
	len-=used; buf+=used;
	if(0==(used=encode(duration,buf,len))) return 0;
	len-=used; buf+=used;
	return origlen-len;
}

void
EventBase::genName() {
	if(!nameisgen)
		return;
	if(genID<numEGIDs) {
		stim_id=std::string("Evt_");
		stim_id+=EventGeneratorNames[genID];
	} else {
		stim_id=std::string("Evt_InvalidGen");
		stim_id+=genID; 
	}
	stim_id+="::";
	char tmp[16];
	snprintf(tmp,16,"0x%x",sourceID);
	stim_id+=tmp;
}

/*! @file
 * @brief Implements EventBase, the basic class for sending events around the system
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.15 $
 * $State: Exp $
 * $Date: 2003/12/05 20:26:42 $
 */

