//-*-c++-*-
#ifndef INCLUDED_WorldStateSerializer_h
#define INCLUDED_WorldStateSerializer_h

#include "Behaviors/BehaviorBase.h"
#include "Shared/Config.h"

class Socket;

//! Copies WorldState into a buffer for transmission over the network
/*! To determine the communication protocol, just look in the
 *  processEvent() function - it's pretty straightforward binary copy
 *  of values */
class WorldStateSerializerBehavior : public BehaviorBase {
public:
  WorldStateSerializerBehavior(); //!< constructor

	virtual void DoStart(); //!< starts listening for sensor update events
	virtual void DoStop(); //!< stops listening for events
	virtual void processEvent(const EventBase& e); //!< core functionality - performs serialization, sends to sockets
	virtual std::string getName() const { return "World State Serializer"; }
	static std::string getClassDescription() {
		char tmp[80];
		sprintf(tmp,"Sends sensor information to port %d and current pid values to port %d",config->main.wsjoints_port,config->main.wspids_port);
		return tmp;
	}

protected:
	//! writes @a value to @a dst and advances @a dst
  template<class T>
  inline static void encode(char **dst, const T& value) {
    memcpy(*dst, &value, sizeof(T));
		// it'd be nice to use network byte order, but we'll save the aibo extra work
		//hostToNetwork(*dst, (char *)&value, sizeof(T));
    (*dst) += sizeof(T);
  }

	//! writes @a length bytes from @a src to @a dst
  template<class T>
  inline static void encode(char **dst, const T * src, int num) {
    memcpy(*dst, src, num*sizeof(T));
    (*dst) += num*sizeof(T);
  }

  Socket *wsJoints; //!< socket for sending current joint data
  Socket *wsPIDs; //!< socket for sending current PID info

private:
  WorldStateSerializerBehavior(const WorldStateSerializerBehavior&); //!< don't call
  WorldStateSerializerBehavior& operator= (const WorldStateSerializerBehavior&); //!< don't call
};

/*! @file
 * @brief Describes WorldStateSerializerBehavior, which copies WorldState into a buffer for transmission over the network
 * @author alokl (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/02/05 23:33:41 $
 */

#endif
