//-*-c++-*-
#ifndef INCLUDED_ViewWMVarsBehavior_h_
#define INCLUDED_ViewWMVarsBehavior_h_

#include "Behaviors/BehaviorBase.h"
#include "Behaviors/Controller.h"
#include "Shared/Config.h"
#include <stdio.h>

//! simply launches the Watchable Memory GUI
class ViewWMVarsBehavior : public BehaviorBase {
public:
	//! constructor
	ViewWMVarsBehavior() : BehaviorBase() {}

	virtual void DoStart() {
		BehaviorBase::DoStart();
		// Open the WalkGUI on the desktop
		Controller::loadGUI("org.tekkotsu.mon.WatchableMemory","WatchableMemory",config->main.wmmonitor_port);
	}

	virtual void DoStop() {
		// Close the GUI
		Controller::closeGUI("WatchableMemory");
		BehaviorBase::DoStop();
	}

	virtual std::string getName() const { return "View WMVars"; }
	static std::string getClassDescription() {
		char tmp[20];
		sprintf(tmp,"%d",config->main.wmmonitor_port);
		return std::string("Brings up the WatchableMemory GUI on port ")+tmp;
	}
};

/*! @file
 * @brief Describes ViewWMVarsBehavior, simply launches the Watchable Memory GUI
 * @author ejt (Creator)
 * 
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.1 $
 * $State: Rel $
 * $Date: 2003/10/10 00:47:52 $
 */

#endif 
