//-*-c++-*-
#ifndef INCLUDED_ToggleHeadLightBehavior_h_
#define INCLUDED_ToggleHeadLightBehavior_h_

#include "Shared/SharedObject.h"
#include "Motion/PostureMC.h"
#include "Shared/ERS220Info.h"

//! opens or closes the head light on an ERS-220
class ToggleHeadLightBehavior : public BehaviorBase {
public:
	//! constructor
	ToggleHeadLightBehavior() : BehaviorBase(), light_id(MotionManager::invalid_MC_ID) {}

	//! opens the head light
	virtual void DoStart() {
		BehaviorBase::DoStart();
		if(state->robotDesign & WorldState::ERS220Mask) {
			SharedObject<PostureMC> pose;
			pose->setOutputCmd(ERS220Info::RetractableHeadLEDOffset,true);
			light_id=motman->addMotion(pose,false);
		}
	}

	//! resets the head light
	virtual void DoStop() {
		motman->removeMotion(light_id);
	}

	static std::string getClassDescription() { return "Opens or closes the head light on an ERS-220"; }

	std::string getName() const { return "ToggleHeadLightBehavior"; }

protected:
	MotionManager::MC_ID light_id; //!< id value of the PostureMC used to control the light
};

/*! @file
 * @brief Defines ToggleHeadLightBehavior, which will open or close the head light on an ERS-220
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.2 $
 * $State: Rel $
 * $Date: 2003/09/02 20:58:49 $
 */

#endif
