//-*-c++-*-
#ifndef INCLUDED_SensorObserverControl_h_
#define INCLUDED_SensorObserverControl_h_

#include "ControlBase.h"
#include "Events/EventListener.h"
#include "StringInputControl.h"
#include "ToggleControl.h"
#include <fstream>

//! allows logging of sensor information to the console or file
class SensorObserverControl : public ControlBase, public EventListener {
public:
	//!constructor
	SensorObserverControl();

	//!opens a custom (embedded) menu to toggle individual sensors
	virtual ControlBase* doSelect();
	
	virtual void refresh();

	//!sends all events received to stdout and/or logfile
	virtual void processEvent(const EventBase& event);

protected:
	//!checks to see if logfilePath differs from the StringInputControl's value and switches it if it is
	void checkLogFile();
	
	//!address of the logfile, if any (empty string is no logfile)
	std::string logfilePath;

	//!if a filename is given, events are logged to here
	std::ofstream logfile;

	ControlBase * helpCtl; //!< control containing help info
	ControlBase * sensorCtl; //!< control of sensor selectors
	ControlBase * buttonCtl; //!< control of buttons selectors
	ControlBase * outputCtl; //!< control of outputs selectors
	ControlBase * dutyCtl; //!< control of duty selectors
	ToggleControl * consoleCtl; //!< turn logging to the console on and off
	StringInputControl * fileCtl; //!< turn logging to a file on and off

	unsigned int numListeners; //!< count of active console or file control so we know if we're actually logging

private:
	SensorObserverControl(const SensorObserverControl& ); //!< don't call
	SensorObserverControl& operator=(const SensorObserverControl& ); //!< don't call

};

/*! @file
 * @brief Describes SensorObserverControl which allows logging of sensor information to the console or file
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:56 $
 */

#endif
