//-*-c++-*-
#ifndef INCLUDED_NullControl_h_
#define INCLUDED_NullControl_h_

#include "ControlBase.h"

//! when activated, this will return immediately  (handy for fake items in a menu)
class NullControl : public ControlBase {
public:

	//!Constructor
	NullControl() : ControlBase() {}
	//!Constructor
	NullControl(const std::string& n) : ControlBase(n) {}
	//!Constructor
	NullControl(const std::string& n, const std::string& d) : ControlBase(n,d) {}

	//@{
	//! returns NULL
	virtual ControlBase * activate(MotionManager::MC_ID , Socket * ) { return NULL; }

	virtual ControlBase * doSelect()    { return NULL; }
	virtual ControlBase * doNextItem()  { return NULL; }
	virtual ControlBase * doPrevItem()  { return NULL; }
	virtual ControlBase * doReadStdIn(const std::string& /*prompt*/=std::string()) { return NULL; }
	virtual ControlBase * takeInput(const std::string& /*msg*/) { return NULL; }
	//@}
};

/*! @file
 * @brief Defines NullControl, which does absolutely nothing (handy for fake items in a menu)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.2 $
 * $State: Rel $
 * $Date: 2003/09/25 15:26:11 $
 */

#endif
