//-*-c++-*-
#ifndef INCLUDED_LoadPostureControl_h_
#define INCLUDED_LoadPostureControl_h_

#include "FileBrowserControl.h"
#include "Motion/PostureMC.h"
#include "Motion/MMAccessor.h"
#include "Motion/EmergencyStopMC.h"
#include "Events/EventRouter.h"
#include <string>

//! Upon activation, loads a position from a file name read from cin (stored in ms/data/motion...)
/*! Should switch this to use a MotionSequence so it can move more leisurely and not "snap" to position */
class LoadPostureControl : public FileBrowserControl, public EventListener {
 public:
	//! Constructor
	LoadPostureControl(const std::string& n, MotionManager::MC_ID estop_id)
		: FileBrowserControl(n,"Loads a posture from user-selected file",config->motion.root), estopid(estop_id), file()
	{
		setFilter("*.pos");
	}
	//! Destructor
	virtual ~LoadPostureControl() {}
	
	//! this is to help reduce the twitch at the end (estop tries to go back to its position when this is removed)
	virtual void processEvent(const EventBase& event) {
		// it still twitches some because there's a bit of lag before we get the
		// event, and estop is already trying to move it back
		erouter->removeListener(this,event);
		MMAccessor<EmergencyStopMC> estop(estopid);
		// why don't we just tell estop to load the file in the first place?
		// estop senses forces on the joints - the force of snapping the joint
		// into position will cause it to reset and not make it into position
		estop->LoadFile(file.c_str());
		estop->setActive(true);
	}
	
	virtual void deactivate() {
		erouter->forgetListener(this);
	}

protected:
	//!does the actual loading of the MotionSequence
	virtual ControlBase* selectedFile(const std::string& f) {
		file=f;
		SharedObject<PostureMC> post;
		post->LoadFile(file.c_str());
		MMAccessor<EmergencyStopMC>(estopid)->setActive(false);
		MotionManager::MC_ID id=motman->addMotion(post,MotionManager::kEmergencyPriority+1,true);
		erouter->addListener(this,EventBase::motmanEGID,id,EventBase::deactivateETID);
		return this;
	}

	MotionManager::MC_ID estopid; //!< MC_ID of the e-stop
	std::string file;             //!< last posture file loaded
};

/*! @file
 * @brief Defines LoadPostureControl, which when activated, loads a position from a file name read from cin (stored in ms/data/motion...)
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.10 $
 * $State: Rel $
 * $Date: 2003/07/26 01:48:03 $
 */

#endif
