//-*-c++-*-
#ifndef INCLUDED_LoadCalibration_h_
#define INCLUDED_LoadCalibration_h_

#include "FileBrowserControl.h"

//! will load calibration parameters from a text file into a forward and backward matrix
template<unsigned int ROWS, unsigned int COLS>
class LoadCalibration : public FileBrowserControl {
public:

	//!Constructor
	LoadCalibration(float f_cal[ROWS][COLS],float b_cal[ROWS][COLS])
		: FileBrowserControl("Load Calibration...","","/ms/data/motion/"), forw_cal(f_cal), back_cal(b_cal)
	{ setFilter("*.txt"); }
	//!Constructor
	LoadCalibration(const std::string& n,float f_cal[ROWS][COLS],float b_cal[ROWS][COLS])
		: FileBrowserControl(n,"","/ms/data/motion/"), forw_cal(f_cal), back_cal(b_cal)
	{ setFilter("*.txt"); }
	//!Constructor
	LoadCalibration(const std::string& n, const std::string& d,float f_cal[ROWS][COLS],float b_cal[ROWS][COLS])
		: FileBrowserControl(n,d,"/ms/data/motion/"), forw_cal(f_cal), back_cal(b_cal)
	{ setFilter("*.txt"); }

protected:
	//!calls readData() for each of the matrices
	virtual ControlBase* selectedFile(const std::string& f) {
		FILE * file=fopen(f.c_str(),"r");
		if(readData(file,forw_cal))
			readData(file,back_cal);
		fclose(file);
		FileBrowserControl::selectedFile(f);
		return NULL;
	}

	//!does the actual loading once a file is selected
	bool readData(FILE * f, float mat[ROWS][COLS]) {
		const unsigned int curl=500;
		char curs[curl];
		for(unsigned int i=0; i<ROWS; i++) {
			fgets(curs,curl,f);
			if(feof(f)) {
				serr->printf("ERROR: short read, got %d lines.\n",(mat==forw_cal?i:i+ROWS));
				return false;
			} else {
				char *c=curs;
				for(unsigned int col=0; col<COLS; col++)
					mat[i][col]=strtod(c,&c);
			}
		}
		return true;
	}

	float (* forw_cal)[COLS]; //!< pointer to the forward calibration matrix
	float (* back_cal)[COLS]; //!< pointer to the backward calibration matrix

private:
	LoadCalibration(const LoadCalibration& ); //!< don't call
	LoadCalibration& operator=(const LoadCalibration& ); //!< don't call
};

/*! @file
 * @brief Defines LoadCalibration, which will load calibration parameters from a text file into a forward and backward matrix
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.2 $
 * $State: Exp $
 * $Date: 2004/01/18 10:16:56 $
 */

#endif
