//-*-c++-*-
#ifndef INCLUDED_FileInputControl_h_
#define INCLUDED_FileInputControl_h_

#include "FileBrowserControl.h"
#include <string>

//! Upon activation, allows user to browse files and select one; stores path in a string
class FileInputControl : public FileBrowserControl {
 public:
	//! Constructor
	FileInputControl()
		: FileBrowserControl("Select file","Select a file","/ms"), file(NULL), myfile()
	{}

	//! Constructor
	FileInputControl(const std::string& nm, const std::string& desc, const std::string& path, std::string* store=NULL)
		: FileBrowserControl(nm,desc,path), file(store), myfile()
	{}

	//! returns the path to file last selected
	const std::string& getLastInput() { return myfile; }

	//! pass pointer to an external string you wish to have set when a file is selected; NULL otherwise
	void setStore(std::string* store) { file=store; }
	
protected:
	virtual ControlBase* selectedFile(const std::string& f) {
		myfile=f;
		if(file!=NULL)
			*file=f;
		return NULL;
	}

	std::string* file;  //!< if we're supposed to store in an external string, this will point to it, otherwise NULL
	std::string myfile; //!< stores last file selected

private:
	FileInputControl(const FileInputControl& ); //!< don't call
	FileInputControl& operator=(const FileInputControl& ); //!< don't call
};

/*! @file
 * @brief Defines FileInputControl, which allows the user to browse files and select one, which is then stored in a string
 * @author ejt (Creator)
 *
 * $Author: ejt $
 * $Name: tekkotsu-2_0_1 $
 * $Revision: 1.1 $
 * $State: Exp $
 * $Date: 2004/01/08 22:39:54 $
 */

#endif
