import java.awt.image.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.io.*;
import java.util.*;

public class VisionSegment extends JFrame implements KeyListener {
  BufferedImage _image;
  String[] imglist;
  byte[] tmap;
  ImageData imageData;
  int curimg;

  public static void main(String args[]) {
    if (args.length<3) {
      System.out.println("usage: java VisionSegment threshold_file colors_file raw_image [raw images]");
      System.exit(1);
    }
    VisionSegment visionSegment=new VisionSegment(args);
    visionSegment.addWindowListener(new WindowAdapter() {
        public void windowClosing(WindowEvent e) { System.exit(0); } });
  }

  public VisionSegment (String args[]) {
    imageData=new ImageData();
    imageData.loadRGBFile(args[2]);

    int[] data=imageData.getRGB();
    tmap=readThresholdMap(args[0]);
    IndexColorModel cmodel=readColorModel(args[1]);

    if (tmap==null || cmodel==null) return;

    setBackground(Color.black);
    setSize(imageData.image_width*2, imageData.image_height*2);
    _image=new BufferedImage(imageData.image_width, imageData.image_height,
        BufferedImage.TYPE_BYTE_INDEXED,cmodel);
   
    segmentImage(data, tmap, imageData.image_width, imageData.image_height);

    imglist=new String[args.length-2];
    curimg=0;
    for (int i=2; i<args.length; i++) {
      imglist[i-2]=args[i];
    }

    show();
    addKeyListener(this);
  }

  void segmentImage(int[] data, byte[] tmap, int width, int height) {
    int size_y=16, size_u=64, size_v=64;
    byte[] imgdata=new byte[data.length];

    for (int i=0; i<data.length; i++) {
      int y=(data[i]>>16)&0xff;
      int u=(data[i]>>8)&0xff;
      int v=data[i]&0xff;
      y=y>>4;
      u=u>>2;
      v=v>>2;
      imgdata[i]=tmap[(y*size_u+u)*size_v+v];
    }
    _image.getRaster().setDataElements(0,0,width,height,imgdata);
    repaint();
  }

  IndexColorModel readColorModel(String colorsfile) {
    int[] cmap=readColorMap(colorsfile);
    if (cmap==null || cmap.length==0) return null;
    byte[] byte_cmap=new byte[cmap.length*3];

    for (int i=0; i<cmap.length; i++) {
      byte_cmap[i*3]=(byte) ((cmap[i]>>16) & 0xff);
      byte_cmap[i*3+1]=(byte) ((cmap[i]>>8) & 0xff);
      byte_cmap[i*3+2]=(byte) (cmap[i] & 0xff);
    }
    IndexColorModel cmodel=new IndexColorModel(7, cmap.length, byte_cmap,
                                               0, false); 
    return cmodel;
  }

  byte[] readThresholdMap(String thresholdfile) {
    try {
      byte[] tmdata=new byte[65536];
      FileInputStream file_tm_fis=new FileInputStream(thresholdfile);
      file_tm_fis.read(tmdata,0,19);
      file_tm_fis.read(tmdata);
      file_tm_fis.close();
      return tmdata;
    } catch (Exception ex) {
      System.out.println("Error reading file "+thresholdfile+": "+ex);
      return null;
    }
  }

  int[] readColorMap(String colorsfile) {
    try {
      BufferedReader reader=new BufferedReader(new FileReader(colorsfile));
      int[] v=new int[32];
      int vnum=0;
      String s=reader.readLine();
      while(s!=null) {
        if (s.length()==0 || s.charAt(0)=='#') { s=reader.readLine(); continue; }
        
        int pos=Integer.parseInt(s.substring(0,s.indexOf(" ")));

        String colorstr=s.substring(s.indexOf("(")+1, s.indexOf(")")).trim();
        String[] colorarr=colorstr.split("\\s+");

        int color=0;
        color|=Integer.parseInt(colorarr[0])<<16;
        color|=Integer.parseInt(colorarr[1])<<8;
        color|=Integer.parseInt(colorarr[2]);

        v[pos]=color;
        if (pos>vnum) vnum=pos;
        s=reader.readLine();
      }
      int[] colors=new int[vnum+1];
      for (int i=0; i<=vnum; i++) {
        colors[i]=v[i];
      }
      return colors;
    } catch (Exception ex) {
      System.out.println("Error reading file "+colorsfile+": "+ex);
      return null;
    }
  }

  public void paint(Graphics graphics) {
    Dimension sz=getSize();
    if (_image!=null)
      graphics.drawImage(_image, 0, 0, sz.width, sz.height, null);
  }

  public void keyPressed(KeyEvent e) {
    if (e.getKeyCode()==KeyEvent.VK_LEFT ||
        e.getKeyCode()==KeyEvent.VK_UP ||
        e.getKeyCode()==KeyEvent.VK_PAGE_UP ||
        e.getKeyCode()==KeyEvent.VK_KP_UP ||
        e.getKeyCode()==KeyEvent.VK_KP_LEFT) {
      curimg--;
      if (curimg<0) curimg+=imglist.length;
      imageData.loadRGBFile(imglist[curimg]);
      int[] data=imageData.getRGB();
      segmentImage(data, tmap, imageData.image_width, imageData.image_height);
    } else if (e.getKeyCode()==KeyEvent.VK_RIGHT ||
        e.getKeyCode()==KeyEvent.VK_DOWN ||
        e.getKeyCode()==KeyEvent.VK_PAGE_DOWN ||
        e.getKeyCode()==KeyEvent.VK_KP_DOWN ||
        e.getKeyCode()==KeyEvent.VK_KP_RIGHT) {
      curimg++;
      if (curimg>=imglist.length) curimg-=imglist.length;
      imageData.loadRGBFile(imglist[curimg]);
      int[] data=imageData.getRGB();
      segmentImage(data, tmap, imageData.image_width, imageData.image_height);
    }
  }
  public void keyReleased(KeyEvent e) { }
  public void keyTyped(KeyEvent e) { }
}
